/*****************************************************************************
 **                            Class MsgDialog                              **
 *****************************************************************************/
//    File: MsgDialog.java
// Descrip: Used to display a modal dialog box giving the user some message.
//
// History: Wed Mar  5 13:49:51 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

public class MsgDialog extends Dialog
{
   private MultiLabel msg;
   private ActiveButton ok;
   
   public MsgDialog(Frame parent, String title, String msg)
   {
      super(parent, title, true);
      setLayout(new BorderLayout());
      this.msg = new MultiLabel(msg, 10, 10, MultiLabel.LEFT);
      add("Center", this.msg);
      ok = new ActiveButton("Ok");
      add("South", ok);
      pack();
   }

   public void setMsg(String msg)
   {
      this.msg.setText(msg);
   }
   
   public boolean handleEvent(Event e)
   {
      if (e.id == Event.ACTION_EVENT && e.target == ok)
         hide();
      else
         return super.handleEvent(e);
      return true;
   }   
}


   
