/*****************************************************************************
 **                            Class MsgWindow                              **
 *****************************************************************************/
//    File: MsgWindow.java
// Descrip: Displays a window with a message to the user.  The window can be
//          set to remove itself after a timeout or it can be persistent until
//          explicitely dismissed by the user.
//
// History: Fri Feb 14 15:54:49 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;
import java.io.File;  // For File.separator

public class MsgWindow extends Frame implements Runnable
{
   /**
    * ICON_DIR contains the path to the icon directory,
    * e.g. <CODE>"/u/qr/algy3/gui/icons/"</CODE>.n
    * 
    * @see #TextInputWindow
    * @author  Micheal S. Hewett    hewett@cs.utexas.edu
    * @date    Wed Mar  5 19:06:19 1997
    * @version 1.0
    * 
    */
   public static String ICON_DIR = null;

   private Thread my_timer;
   private int timeout;
   private WinOwner owner;
   private int ID;
   private ActiveButton dismiss;

   public MsgWindow(int ID, int timeout, String msg)
   {
      this(ID, timeout, msg, null);
   }

   public MsgWindow(int ID, int timeout, String msg, WinOwner owner)
   {
      super("Message");
      
      // Initialize the path to the icon directory, if necessary
      if (ICON_DIR == null)
      {
	String algyHomePath = System.getProperty("ALGY.HOME");
	if (algyHomePath == null)
	{
	  System.err.print("-DALGY.HOME not specified.  Using default path: ");
	  algyHomePath = "/u/qr/algy3/";
	  System.err.println(algyHomePath);
	}
	ICON_DIR = algyHomePath + "gui" + File.separator + "icons" + File.separator;
      }

      this.owner = owner;
      this.ID = ID;
      this.timeout = timeout;
      my_timer = null;

      if (timeout > 0) 
      {
         // Set up the window
         setFont(InputWindow.input_font);
         add("West", new ImageLabel(
            "file:" + ICON_DIR + File.separator + "icon.note.gif"));
         add("Center", new MultiLabel(msg));
         WinPosition.showWin(this);

         // Set up timer thread and start it
         this.timeout = timeout;
         my_timer = new Thread(this);
         my_timer.start();
      }
      else 
      {
         // Set up the prompt
         add("West", new ImageLabel(
            "file:" + ICON_DIR + File.separator + "icon.note.gif"));
         MultiLabel label = new MultiLabel(msg);
         label.setFont(InputWindow.input_font);
         add("Center", label);

         // Set up dismiss button
         dismiss = new ActiveButton("Dismiss");
         add("South", dismiss);

         // Display window
         WinPosition.showWin(this);
      }
   }

   public synchronized void dispose() 
   { 
      if (my_timer != null)
      {
         /* You might think that we should call super.dispose() regardless
          * of the status of my_timer.  However, if my_timer is dead then
          * it ran this function (possibly indirectly through the WinOwner
          * owner) before exiting and the window has already been disposed 
          * of. */
         if (my_timer.isAlive()) 
         {
            super.dispose();
            my_timer.stop(); 
         }
      }
      else
         super.dispose();
   }

   public void run()
   {
      try { Thread.sleep(timeout * 1000); }
      catch (InterruptedException e) {}

      if (owner != null) owner.ownedWindowRequestsKill(this);
      else               dispose();
   }

   public boolean handleEvent(Event e)
   {
      if ((e.id == Event.ACTION_EVENT && e.target == dismiss) ||
          e.id == Event.WINDOW_DESTROY)
      {
         if (owner != null) owner.ownedWindowRequestsKill(this);
         else               dispose();
         return true;
      }
      else
         return super.handleEvent(e);
   }
}

