// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  TextFileWindow.java  - Uses the LogWindow class to display a text file.
//
//  4 Mar 1997
//
// -------------------------------------------------------------------

package lib.display;

import java.awt.*;
import java.io.*;


/**
 * Displays the contents of a text file in a non-modal window.
 * 
 * Example:
 * <pre>
 *   fw = new TextFileWindow("path/filename.suf", "Financial Advice");
 * </pre>
 * @see lib.display.LogWindow
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Tue Mar  4 19:33:39 1997
 * @version 1.0
 *
 */
public class TextFileWindow extends LogWindow
{
  /**
   * Send in the file to be displayed and the title of the window.
   * 
   * @exception FileNotFoundException
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Tue Mar  4 19:33:39 1997
   * @version 1.0
   * 
   */
  public TextFileWindow(String filename, String title) throws FileNotFoundException
  {
    super(0, title);
    
    DataInputStream s;
    String          line;

    // Open the file.
    try {
      s = new DataInputStream(new FileInputStream(filename));
    }
    catch (FileNotFoundException fe)
      { throw new FileNotFoundException(filename); }
    catch (IOException e)
      { System.err.println("IOException on " + filename + ": " + e);
        return;
      }

    // Copy the file to the window.
    while (true)
    {
      try { line = s.readLine(); }
      catch (IOException e1)
	{ try { s.close(); } catch (IOException e2) {}
	  return;
	}

      if (line == null)
	break;
      else
	appendText(line + "\n");
    }

    try { s.close(); } catch (IOException e3) {}
  }


  public boolean mouseUp(Event e, int x, int y)
  {
    this.hide();
    return true;
  }


  public boolean handleEvent(Event e)
  {
    switch (e.id) {
      case Event.WINDOW_DESTROY:
	//	case Event.UP:     // this should be MOUSE_UP
	this.hide();
	return true;
    }
    return super.handleEvent(e);
  }
  
}
