/*****************************************************************************
 **                            Class TextWindow                             **
 *****************************************************************************/
//    File: TextWindow.java
// Descrip: Displays window with specified text in a text area.  Good for 
//          showing long messages or other data not suitable for display in
//          a MsgWindow.
//
// History: Fri Feb 14 15:57:37 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

public class TextWindow extends Frame
{
   private TextArea textarea;
   private ActiveButton dismiss;
   private WinOwner owner;
   private int ID;

   public TextWindow(int ID, String title, String text)
   {
      this(ID, title, text, null);
   }
   
   public TextWindow(int ID, String title, String text, WinOwner owner)
   {
      super(title);

      // Count newlines in text in order to know how 
      // many lines to allocate in the window
      int rows = 1;
      for (int i = 0; i < text.length(); ++i)
         if (text.charAt(i) == '\n') ++rows;
      if (rows > 35) rows = 35;
      if (rows < 10) rows = 10;

      this.owner = owner;
      this.ID = ID;
      setLayout(new BorderLayout());
      textarea = new TextArea(rows, 60);
      textarea.setEditable(false);
      textarea.setFont(new Font("Courier", Font.PLAIN, 12));
      textarea.appendText(text);
      add("Center", textarea);
      dismiss = new ActiveButton("Dismiss");
      add("South", dismiss);

      // Display window
      WinPosition.showWin(this);
   }
   
   public boolean handleEvent(Event e)
   {
      if ((e.id == Event.ACTION_EVENT && e.target == dismiss) ||
          e.id == Event.WINDOW_DESTROY)
      {
         if (owner != null) owner.ownedWindowRequestsKill(this);
         else               dispose();
         return true;
      }
      else
         return super.handleEvent(e);
   }

}
