/*****************************************************************************
 **                           Interface WinOwner                            **
 *****************************************************************************/
//    File: WinOwner.java
// Descrip: See java doc comments below
//
// History: Fri Feb 14 13:54:30 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;

/** 
 * This class arose in developing the GuiServer application.  We wanted to
 * be able to use the simple standalone windows which that applications uses
 * in other applications but they had hard-coded ties to the GuiServer
 * class.  So, we modified the various classes to access the functionality
 * they need from the GuiServer class through an abstract interface.
 * Now other applications can support this interface and use the classes
 * developed for GuiServer.
 */
public interface WinOwner 
{
   /** Called by one of the standalone windows when it wants to go away
    * (in response to the user pressing dismiss or something). It expects
    * the WinOwner to call dispose on the window in response to the
    * call.  If the window's owner pointer is null, then it will skip 
    * calling this function and call dispose itself.
    */
   public void ownedWindowRequestsKill(Window win);

   /** Called by one of the standalone windows when it has gotten a
    *  response from the user.
    */
   public void ownedWindowOutput(Window win, String text);
}

  
