/*****************************************************************************
 **                           Class YorN_PWindow                            **
 *****************************************************************************/
//    File: YorN_PWindow.java
// Descrip: Ask the user a simple yes of no question.
//
// History: Fri Feb 14 15:47:42 1997 created by Spencer Bishop
// $Id$
/*****************************************************************************/

package lib.display;

import java.awt.*;
import java.io.File;  // For File.separator

public class YorN_PWindow extends InputWindow
{
   /**
    * ICON_DIR contains the path to the icon directory,
    * e.g. <CODE>"/u/qr/algy3/gui/icons/"</CODE>.n
    * 
    * @see #TextInputWindow
    * @author  Micheal S. Hewett    hewett@cs.utexas.edu
    * @date    Wed Mar  5 19:06:19 1997
    * @version 1.0
    * 
    */
   public static String ICON_DIR = null;

   private ActiveButton yes;
   private ActiveButton no;
   
   public YorN_PWindow(int ID, String prompt) 
   { 
      this(ID, prompt, null, null, false);
   }

   public YorN_PWindow(int ID, String prompt, WinOwner owner)
   {
      this(ID, prompt, owner, null, false);
   }

   public YorN_PWindow(int ID, String prompt, Frame parent, boolean modal)
   {
      this(ID, prompt, null, parent, modal);
   }
   
   public YorN_PWindow(int ID, String prompt, WinOwner owner,
                       Frame parent, boolean modal)
   {
      super(ID, "Question", owner, parent, modal);

      // Initialize the path to the icon directory, if necessary
      if (ICON_DIR == null)
      {
	String algyHomePath = System.getProperty("ALGY.HOME");
	if (algyHomePath == null)
	{
	  System.err.print("-DALGY.HOME not specified.  Using default path: ");
	  algyHomePath = "/u/qr/algy3/";
	  System.err.println(algyHomePath);
	}
	ICON_DIR = algyHomePath + "gui" + File.separator + "icons" + File.separator;
      }

      // Set up the prompt
      add("West", new ImageLabel(
         "file:" + ICON_DIR + File.separator + "icon.ques.gif"));
      MultiLabel center = new MultiLabel(prompt);
      center.setFont(InputWindow.input_font);
      add("Center", center);

      // Set up response buttons
      Panel south = new Panel();
      south.setLayout(new GridLayout(1, 5));
      south.add(new Label(""));
      yes = new ActiveButton("Yes"); south.add(yes);
      south.add(new Label(""));
      no = new ActiveButton("No"); south.add(no);
      south.add(new Label(""));
      add("South", south);

      if (!isModal()) 
      {
         WinPosition.showWin(this);
         yes.requestFocus();
      }
   }

   public boolean handleEvent(Event e)
   {
      if (e.id == Event.ACTION_EVENT &&
          (e.target == yes || e.target == no))
      {
         String ans;
         if (e.target == yes) ans = ":YES";
         else                 ans = ":NO";
         if (owner != null) 
         {
            owner.ownedWindowOutput(this, ans);
            owner.ownedWindowRequestsKill(this);
         }
         else
            dispose();
         user_input = ans;
         return true;
      }
      else
         return super.handleEvent(e);
   }
}
