
package lib.dynatype;

import java.lang.*;
import java.io.*;



//------------------------------  LispCharacter  -------------------------------

public class LispCharacter extends LispAtom
{
  // ----- Constants  ------------

  public static final LispCharacter COLON = new LispCharacter(':');
  public static final LispCharacter DOT   = new LispCharacter('.');
  public static final LispCharacter ZERO  = new LispCharacter('0');

  // ----- fields  ------------

  private  char value;
		
  // ----- static initializer  -------------


  // ----- Constructors  ------------

  public LispCharacter(char theChar) { value = theChar; }
  public LispCharacter()             { value = 'm';     }  // For Mike!


  // ----- non-LISP methods  ------------
  public void internal_princ(PrintStream os) { os.print(value); }

  public void internal_prin1(PrintStream os) { os.print("#\\" + value); }

  public void internal_print(PrintStream os) { os.print("#\\" + value); }

  char getValue() { return value; }

  public String toString() { return String.valueOf(value); }

  // ----- LISP methods  ------------

  public LispValue     characterp ()  { return T; }

  public LispValue eql(LispValue val)
  {
    if (val instanceof LispCharacter)
      if (this.value == ((LispCharacter)val).getValue())
	return T;
      else
	return NIL;
    else
      return super.eql(val);
  }

  public LispValue equal(LispValue val)
  {
    return eql(val);
  }

  public LispValue     type_of     ()  { return LispValue.CHARACTER_TYPE;   }


};
