
package lib.dynatype;

import java.io.*;

// See LispValue.java


//-------------------------------  LispCons  --------------------------------

public class LispCons extends LispConsOrNil 
{
  protected LispValue  carCell;
  protected LispValue  cdrCell;
		
  public  LispCons(LispValue theCar, LispValue theCdr)
  { carCell = theCar; cdrCell = theCdr; }
  public  LispCons()
  { carCell = LispValue.NIL; cdrCell = LispValue.NIL; }

  public void internal_prin1(PrintStream os)
  {
    os.print("(");
    carCell.internal_prin1(os);
    cdrCell.internal_prin1_as_cdr(os);
    os.print(")");
  }

  public void internal_prin1_as_cdr(PrintStream os)
  {
    os.print(" ");
    carCell.internal_prin1(os);
    cdrCell.internal_prin1_as_cdr(os);
  }


  public void internal_print(PrintStream os)
  {
    os.print("(");
    carCell.internal_print(os);
    (cdrCell).internal_print_as_cdr(os);
    os.print(")");
  }
  

  public void internal_print_as_cdr(PrintStream os)
  {
    os.print(" ");
    carCell.internal_print(os);
    (cdrCell).internal_print_as_cdr(os);
  }
  

  public boolean basic_consp() { return true; }
		

  /**
   * <code>toString()</code> returns a printed representation
   * of the form (as printed by <code>(prin1)</code>) in 
   * a Java string.
   * @return String The value in a string.
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Wed Feb 19 17:18:50 1997
   * @version 1.0
   * 
   */
  public String toString()
  {
    StringBuffer buf = new StringBuffer();

    buf.append("(");
    buf.append(carCell.toString());
    buf.append(cdrCell.toStringAsCdr());
    buf.append(")");

    return buf.toString();
  }

  public String toStringAsCdr()
  {
    StringBuffer buf = new StringBuffer();

    buf.append(" ");
    buf.append(carCell.toString());
    buf.append(cdrCell.toStringAsCdr());

    return buf.toString();
  }



  // --------  LISP methods  --------------

  public LispValue append(LispValue otherList)
  {
    return LispValue.VF.makeCons(car(), cdr().append(otherList));
  }


  public LispValue assoc(LispValue index)
  {
    LispValue  ptr = this;
    LispValue  value;
	
    while (!ptr.basic_null())
    {
      value = ptr.car();
		
      if (!ptr.basic_consp())
      {
	throw new LispValueNotAListException("An argument to ASSOC");
      }
		
      if (index.eql(value.car()) == LispValue.T)
      {
	return value;	
      }
      ptr = ptr.cdr();
    }
    return NIL;
  }

  public LispValue car() { return carCell; }
  public LispValue cdr() { return cdrCell; }

  public LispValue     consp        ()  { return T;  }

  public LispValue     copy_list    ()
  {
    return LispValue.VF.makeCons(car(), cdr().copy_list());
  }
  
  public LispValue     first        ()  { return carCell;         }
  public LispValue     second       ()  { return cdr().first();   }
  public LispValue     third        ()  { return cdr().second();  }
  public LispValue     fourth       ()  { return cdr().third();   }
  public LispValue     fifth        ()  { return cdr().fourth();  }
  public LispValue     sixth        ()  { return cdr().fifth();   }
  public LispValue     seventh      ()  { return cdr().sixth();   }
  public LispValue     eighth       ()  { return cdr().seventh(); }
  public LispValue     ninth        ()  { return cdr().eighth();  }
  public LispValue     tenth        ()  { return cdr().ninth();   }

  public LispValue last()
  {
    LispValue ptr = this;
	
    while (!ptr.cdr().basic_null())
       if (!ptr.basic_consp())
       {
	 throw new LispValueNotAListException("An argument to LAST");
       }
       else
	  ptr = ptr.cdr();
    return ptr;
  }

  public LispValue length()
  {
    LispValue ptr = this;
    long      len = 0;
	
    while (!ptr.basic_null())
    {
      ++len;
      if (!ptr.basic_consp())
      {
	throw new LispValueNotAListException("An argument to LENGTH");
      }
      else
	 ptr = ptr.cdr();
    }
    return new LispInteger(len);
  }

  public LispValue member(LispValue elt)
  {
    if (car().eql(elt) == LispValue.T)
    {
      return this;
    }
    else
       return cdr().member(elt);
  }

  public LispValue     rassoc(LispValue index)
  {
    LispValue  ptr   = this;
    LispValue value;
	
    while (!ptr.basic_null())
    {
      value = ptr.car();
		
      if (!ptr.basic_consp())
      {
	throw new LispValueNotAListException("The second argument to RASSOC");
      }
		
      if (index.eql(value.cdr()) == LispValue.T)
	 return value;	
      ptr = ptr.cdr();
    }
    return NIL;
  }

  public LispValue remove(LispValue elt)
  {
    if (car().eql(elt) == LispValue.T)
       return cdr().remove(elt);
    else
       return new LispCons(car(), (cdr().remove(elt)));
  }

  public LispValue     rplaca(LispValue  newCar)
  { carCell = newCar; return this; };
  public LispValue     rplacd(LispValue  newCdr)
  { cdrCell = newCdr; return this; };
  
  public LispValue subst(LispValue oldValue, LispValue newValue)
  {
    if (oldValue.eql(car()) == LispValue.T)
       return new LispCons(newValue, cdr().subst(oldValue, newValue));
    else
       return new LispCons(car(), cdr().subst(oldValue, newValue));
  }

  public LispValue     type_of     ()  { return LispValue.CONS_TYPE;   }

};

