package lib.dynatype;


//-----------------------------  LispConsOrNil  -----------------------------

public abstract class LispConsOrNil extends LispValue
{
  public boolean basic_consp()  { return true; }
  public boolean basic_listp()  { return true; }

  // ------ LISP methods  ----------

  public LispValue butlast()
  {
    if (cdr().consp() != T)
      return NIL;
    else
      return (VF.makeCons(car(), cdr().butlast()));
  }

  public LispValue elt (LispValue index)
  {
    long indexValue;

    if (!index.basic_integerp())
      throw new LispValueNotAnIntegerException("to ELT");
    else
    {
      indexValue = ((LispInteger)index).getValue();
      if ((indexValue < 0) || (indexValue > (((LispInteger)this.length()).getValue() - 1)))
	throw new LispIndexOutOfRangeException(String.valueOf(indexValue) + " to ELT");

      // All is okay
      LispValue element = this;

      for (int i = 0; i < indexValue; ++i)  element = element.cdr();

      return element.car();
    }
  }


  public LispValue length ()
  {
    long       count = 0;
    LispValue  ptr   = this;

    while (ptr != NIL) { ++count; ptr = ptr.cdr(); }

    return new LispInteger(count);
  }
      
  public LispValue     listp        ()  { return T;  }

  public LispValue nreverse ()
  {
    LispValue head    = this;
    LispValue next    = cdr();
    LispValue result  = NIL;
    
    // p stays one ahead of the main list pointer.
    while (head != NIL)
    {
      next = head.cdr();     // Save pointer to next element in list.
      head.rplacd(result);   // Alter cdr of head.
      result = head;         // Reset pointer to top of result
      head = next;           // Start over with the next element of the list.
    }

    return result;
  }

  public LispValue reverse ()
  {
    LispValue result = NIL;
    
    for (LispValue p=this; p != NIL; p = p.cdr() )
      result = new LispCons(p.car(), result);

    return result;
  }


}


