package lib.dynatype;

import java.lang.*;
import java.io.*;

// See LispValue.java for documentation



//------------------------------  LispConstant  ------------------------------

// The value of a constant can't be changed.
// We allow the value to be set only if it is unbound.

public class LispConstant extends LispSymbol
{
  // CONSTRUCTORS 

  public LispConstant(String symbolName)
  {
    super(symbolName);
  }

  public LispConstant(LispString symbolNameString)
  {
    super(symbolNameString);
  }

  public LispConstant(String symbolName, LispValue itsValue)
  {
    super(symbolName);
    value = itsValue;
  }

  public LispConstant(LispString symbolNameString, LispValue itsValue)
  {
    super(symbolNameString);
    value = itsValue;
  }


  // ------  BASIC (non-LISP) methods  --------

  public boolean basic_constantp()
  { return true; }


  // ------  LISP methods  --------


  public LispValue setf_symbol_value(LispValue newValue)
  {
    if (value == null)
      return value = newValue;
    else
      throw new LispConstantRedefinedException(name.getValue());
  }

};

