// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  LispInteger.java  - Integer data type for Lisp.
//
//  14 Feb 1997
//
// -------------------------------------------------------------------

package lib.dynatype;

import java.lang.*;
import java.io.*;



//------------------------------  LispInteger  -------------------------------

public class LispInteger extends LispNumber 
{
  public static final LispInteger  ZERO = new LispInteger((long) 0);

  private  long value;
		
  // ---  static initializer  ---

  // ---  Constructors  ---

  public LispInteger(long theValue) { value = theValue; }
  public LispInteger()              { value = 0;        }
		
  // ---  non-LISP methods  ---
  public long    getValue()            { return value; }
  public double  getDoubleValue()      { return value; }

  public void    internal_prin1(PrintStream os) { os.print(value); }
  public void    internal_print(PrintStream os) { os.print(value); }
  public boolean basic_integerp()      { return true; }

  public String  toString() { return String.valueOf(value); }


  // ---  LISP methods  ---

  public LispValue eql(LispValue val)
  {
    if (val instanceof LispInteger)
    {
      if (this.value == ((LispInteger)val).getValue())
	return T;
      else
	return NIL;
    }
    else
      return super.eql(val);
  }


  public LispValue integerp()  { return T; }

  public LispValue     type_of     ()  { return LispValue.INTEGER_TYPE;   }

  public LispValue zerop()
  {
    if (value == 0)
      return T;
    else
      return NIL;
  }

};
