package lib.dynatype;

import java.lang.*;
import java.io.*;

// See LispValue.java for documentation



//------------------------------  LispKeyword  ------------------------------

// A keyword is a constant which evaluates to itself.
// It is supposed to be in its own package, but we 
// don't have packages in this LISP.

public class LispKeyword extends LispConstant
{

  public LispKeyword(String symbolName)
  {
    super(symbolName);
    value = this;
  }

  public LispKeyword(LispString symbolNameString)
  {
    super(symbolNameString);
    value = this;
  }


  // ------  BASIC (non-LISP) methods  --------

  public boolean basic_keywordp()
  { return true; }


  // ------  LISP methods  --------

  public LispValue     keywordp     ()  { return T; }

  public LispValue setf_symbol_value(LispValue newValue)
  {
    throw new LispConstantRedefinedException(name.getValue());
  }

};

