package lib.dynatype;

import java.lang.*;
import java.io.*;

// See LispValue.java for documentation





//--------------------------------  LispNil  --------------------------------
//
// This is used only for NIL.  Since NIL is both a degenerate list and 
// a symbol, it causes some programming difficulties.  Using this resolves 
// those problems.

public class LispNil extends LispConsOrNil
{
  private  LispString name;
  private  LispValue  value;
		

  LispNil(String     symbolName)
    { name = new LispString(symbolName); value = this; }

  LispNil(LispString symbolNameString)
    { name  = symbolNameString; value = this; }


  public void internal_prin1(PrintStream os)        { os.print("NIL"); }
  public void internal_prin1_as_cdr(PrintStream os) { /* Do Nothing */ }

  public void internal_print(PrintStream os)        { os.print("NIL"); }
  public void internal_print_as_cdr(PrintStream os) { /* Do Nothing */ }
		

  public String toString()      { return "NIL"; }
  public String toStringAsCdr() { return ""; }


  public boolean basic_atom()      { return true;  }
  public boolean basic_consp()     { return false; }
  public boolean basic_constantp() { return true;  }
  public boolean basic_symbolp()   { return true;  }
  public boolean basic_null()      { return true;  }
		
  //public operator unsigned long  () { return (unsigned long)(*name); };  // Used for hashing.

  public LispValue     append(LispValue otherList) { return otherList; }
  public LispValue     assoc(LispValue index)      { return NIL; }
  public LispValue     atom()                      { return T;   }
  public LispValue     boundp()                    { return T;   }
  public LispValue     butlast()                   { return NIL; }
  public LispValue     car()                       { return NIL; }
  public LispValue     cdr()                       { return NIL; }
  public LispValue     copy_list()                 { return NIL; }
  public LispValue     elt(LispValue index)        { return NIL; }

  public LispValue     first        ()  { return NIL; }
  public LispValue     second       ()  { return NIL; }
  public LispValue     third        ()  { return NIL; }
  public LispValue     fourth       ()  { return NIL; }
  public LispValue     fifth        ()  { return NIL; }
  public LispValue     sixth        ()  { return NIL; }
  public LispValue     seventh      ()  { return NIL; }
  public LispValue     eighth       ()  { return NIL; }
  public LispValue     ninth        ()  { return NIL; }
  public LispValue     tenth        ()  { return NIL; }

  public LispValue     last()                    { return NIL; }
  public LispValue     length()                  { return new LispInteger(0);}
  public LispValue     member(LispValue elt)     { return NIL; }
  public LispValue     nreverse(LispValue index) { return NIL; }
  
  public LispValue     lisp_null    ()           { return T;   }
  public LispValue     rassoc(LispValue index)   { return NIL; }
  public LispValue     remove(LispValue elt)     { return NIL; }
  public LispValue     reverse(LispValue elt)    { return NIL; }
  public LispValue     rplaca(LispValue  newCar) { return NIL; }
  public LispValue     rplacd(LispValue  newCdr) { return NIL; }

  public LispValue setf_symbol_function(LispValue newFunction)
  {
    throw new LispConstantRedefinedException(name.getValue());
  }

  public LispValue     setf_symbol_value(LispValue newValue)
  {
    if (value == null)
      return value = newValue;
    else
      throw new LispConstantRedefinedException(name.getValue());
  }

  public LispValue     symbolp()                 { return T;   }

  public LispValue     subst(LispValue oldValue, LispValue newValue)
  { return NIL; }

  public LispValue     type_of     ()  { return LispValue.NULL_TYPE;   }

};


