package lib.dynatype;

//-------------------------------  LispNumber  ---------------------------------

public abstract class LispNumber extends LispAtom
{		
  public   boolean    basic_numberp()  { return true; }
  abstract double     getDoubleValue();


  // ---- LISP functions -------------

  public LispValue    numberp()  { return T; }


  // Arithmetic functions

  public LispValue     add         (LispValue  args)
  {
    // The list of numbers has already been evaluated.
    // Terminate if we hit any non-numbers.
    double    sum = this.getDoubleValue();
    boolean   allIntegers = (this.integerp() == T);
    LispValue addend;

    while (args != NIL) 
    {
      addend = args.car();
      if (addend.numberp() != T)
      {
	super.add(args.car());
	return(NIL);
      }
      
      /* Done with error-checking.  Let's do it. */
      if (allIntegers && (addend.floatp() == T))
	allIntegers = false;

      if (addend.floatp() == T)
	sum += ((LispReal)addend).getValue();
      else
	sum += ((LispInteger)addend).getValue();
      
      args = args.cdr();
    };
    
    if (allIntegers)
      return(VF.makeInteger((long)sum));
    else
      return(VF.makeReal(sum));
  }


  public LispValue     divide      (LispValue   args)
  {
    double    quotient     = this.getDoubleValue();
    boolean   allIntegers  = (this.integerp() == T);
    LispValue term;
    int       argCount     = 1;

    while (args != NIL) 
    {
      term = args.car();             /* Arglist is already evaluated. */
      if (term.numberp() != T)
      {
	super.divide(args.car());
	return(NIL);
      }

      /* Done with error-checking.  Let's do it. */
      ++argCount;
      
      if (allIntegers && (term.floatp() == T))
	allIntegers = false;
      
      if (argCount == 1)
	if (term.floatp() == T)
	  quotient = ((LispReal)term).getValue();
	else
	  quotient = ((LispInteger)term).getValue();

      else    
	if (term.zerop() == NIL)
	{
	  if (term.floatp() == T)
	    quotient = quotient / ((LispReal)term).getValue();
	  else
	    quotient = quotient / ((LispInteger)term).getValue();
        }
	else
	  {
	    System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
	    return(NIL);
	  }
      
      args = args.cdr();
    }
    
    if (argCount == 1)           /* Have to handle n-arg differently from 1-arg */
      if (quotient != 0.0)
    	quotient = 1.0 / quotient;
      else
      {
	System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
	return(NIL);
      }
      
    if (allIntegers && (quotient == (long)quotient))
    {
      return(VF.makeInteger((long)quotient));
    }
    else
      return(VF.makeReal(quotient));
  }


  public LispValue     multiply    (LispValue  args)
  {
    double     product     = this.getDoubleValue();
    boolean    allIntegers = (this.integerp() == T);
    LispValue  term;

    while (args != NIL) 
    {
      term = args.car();
      if (term.numberp() != T)    /* Improve speed by not evaling? */
      {
	super.multiply(args.car());
	return(NIL);
      }

      /* Done with error-checking.  Let's do it. */
      if (allIntegers && (term.floatp() == T))
	allIntegers = false;

      if (term.floatp() == T)
	product *=  ((LispReal)term).getValue();
      else
	product *=  ((LispInteger)term).getValue();

      args = args.cdr();
    }

    if (allIntegers)
      return(VF.makeInteger((long)product));
    else
      return(VF.makeReal(product));
  }


  public LispValue     subtract    (LispValue  args)
  {
    double    result      = - this.getDoubleValue();
    boolean   allIntegers = (this.integerp() == T);
    LispValue term;
    int       argCount = 1;

    while (args != NIL) 
    {
      term = args.car(); /* Arglist is already evaluated. */
      if (term.numberp() == NIL)
      {
	super.subtract(args.car());
	return(NIL);
      }
      
      /* Done with error-checking.  Let's do it. */
      ++argCount;
      
      if (allIntegers && (term.floatp() == T))
	allIntegers = false;
      
      if (argCount == 2)           /* Have to handle n-arg differently from 1-arg */
	result = -1.0 * result;
      
      if (term.floatp() == T)
	result -= ((LispReal)term).getValue();
      else
	result -= ((LispInteger)term).getValue();
      
      args = args.cdr();
    };
    
    if (allIntegers)
      return(VF.makeInteger((long)result));
    else
      return(VF.makeReal(result));
  }
}
