
package lib.dynatype;

import java.lang.*;
import java.io.*;



//-------------------------------  LispReal  ---------------------------------

public class LispReal extends LispNumber 
{
  private  double value;
		
  public void internal_print(PrintStream os) { os.print(value); }
  public void internal_prin1(PrintStream os) { os.print(value); }

  public LispReal(double theValue) { value = theValue; }
  public LispReal()                { value = 0.0; }

  public double getValue()        { return value; }
  public double getDoubleValue()  { return value; }


  public String toString() { return String.valueOf(value); }



  public LispValue eql(LispValue val)
  {
    if (val instanceof LispReal)
    {
      if (this.value == ((LispReal)val).getValue())
	return T;
      else
	return NIL;
    }
    else
      return super.eql(val);
  }

  public LispValue floatp   ()  { return T; }

  public LispValue type_of  ()  { return LispValue.DOUBLE_FLOAT_TYPE;   }

  public LispValue zerop    ()
  {
    if (value == 0.0)
      return T;
    else
      return NIL;
  }

};

