package lib.dynatype;

import java.lang.*;
import java.io.*;

// See LispValue.java for documentation


//-------------------------------  LispString  ------------------------------

public class LispString extends LispAtom 
{
  // -----  Fields  -----
  private  String str;
		
  // -----  Constructors  -----
  public LispString(String strName)
  { str = strName; }

  // -----  non-LISP methods  -----

  public String getValue() { return str; }

  public void internal_princ(PrintStream os)	
  { os.print(str); }

  public void internal_prin1(PrintStream os)	
  { os.print("\"" + str + "\""); }

  public void internal_print(PrintStream os)	
  { os.print("\"" + str + "\""); }


  public String toString() { return "\"" + str + "\""; }


  // -----  LISP methods  ----------

   public LispValue elt (int index)
   {
      return elt(new LispInteger(index)); 
   }

  public LispValue elt (LispValue index)
  {
    long indexValue;

    if (!index.basic_integerp())
      throw new LispValueNotAnIntegerException("to ELT");
    else
    {
      indexValue = ((LispInteger)index).getValue();
      if ((indexValue < 0) || (indexValue >= str.length()))
	throw new LispIndexOutOfRangeException(String.valueOf(indexValue) + " to ELT");

      // All is okay - return the element, which is a character.
      return new LispCharacter(str.charAt((int) indexValue));
    }
  }
  
  public LispValue     first        ()  { return elt(0); }
  public LispValue     second       ()  { return elt(1); }
  public LispValue     third        ()  { return elt(2); }
  public LispValue     fourth       ()  { return elt(3); }
  public LispValue     fifth        ()  { return elt(4); }
  public LispValue     sixth        ()  { return elt(5); }
  public LispValue     seventh      ()  { return elt(6); }
  public LispValue     eighth       ()  { return elt(7); }
  public LispValue     ninth        ()  { return elt(8); }
  public LispValue     tenth        ()  { return elt(9); }

  public LispValue length()
  { return new LispInteger(str.length()); }

  public LispValue     stringp      ()     { return T; }

  public LispValue     type_of     ()  { return LispValue.STRING_TYPE;   }

};

