;;;; -*- Mode:Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

(in-package :user)

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; Copyright (c) 1997 by Micheal Scott Hewett
;;;
;;; This code may be used by anyone for any project, but may not
;;; be sold in source or object form without permission.
;;; If in doubt, follow the GNU "copyleft" guidelines.
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;;; (Contact: hewett@cs.utexas.edu or hewett@cs.stanford.edu)
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;;; ********************************************************************
;;;
;;; io.lisp   -  Load the I/O library for Algernon
;;;
;;; Mike Hewett, Spencer Bishop      16 January 1997
;;;
;;; The user-level routines are documented in the file "design.text"
;;; and in <http://www.cs.utexas.edu/users/qr/algy/io-library.html>
;;;
;;; ********************************************************************


;;; Algy I/O package

#-GCL
(defpackage "ALGY-IO"
  (:use     "COMMON-LISP")
  (:export  )
  )


#+GCL
(unless (find-package :ALGY-IO)
  (make-package "ALGY-IO"
		:use      (list (find-package :LISP)))
  )


(defparameter *algy-library-path*
       (concatenate 'string @algy-gui-path "ioserver/"))

(defun load-algy-library (name)

  (load (concatenate 'string *algy-library-path* name))
  )


(load-algy-library "io-main")
(load-algy-library "io-gui")
(load-algy-library "io-text")

