// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  ActiveMenuItem.java  - A menu bar with "active" items so that the
//                         main event loop doesn't need to process the
//                         button events on the menu.
//
//  12 Feb 1997
//
// -------------------------------------------------------------------

package lib.menu;

import java.awt.*;


/**
 * ActiveMenuItem extends MenuItem with a doAction
 * method.  When a mouse event occurs on the menu
 * item, simply call its doAction() method rather
 * than trying to figure out in the main event loop
 * how to handle the event.
 *
 * This is an abstract class.  You may wish to make
 * make an abstract descendant of this class that 
 * embodies the behavior of menu items in your
 * particular application.
 *
 * Example:
 * <pre>
 * class QuitMenuItem extends ActiveMenuItem
 * {
 *   public QuitMenuItem(String label)
 *   {
 *     super(label);
 *   }
 *
 *   public boolean doAction()
 *   {
 *     System.exit(0);
 *     return false;
 *   }
 * }
 * </pre>
 * @see java.awt.MenuItem
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Wed Feb 12 09:25:18 1997
 * @version 1.0
 *
 */
public abstract class ActiveMenuItem extends MenuItem
{
  /**
   * The constructor takes a string that becomes the
   * label of the menu item.
   * @see java.awt.MenuItem
   * @param String label
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Wed Feb 12 09:29:02 1997
   * @version 1.0
   * 
   */
  public ActiveMenuItem(String label)
  {
    super(label);
  }

  /**
   * Performs whatever action the menu is supposed
   * to perform.  The default action is to do nothing.
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Wed Feb 12 09:30:15 1997
   * @version 1.0
   * 
   */
  public boolean doAction()
  {
    return false;
  }
}
