// ===================================================================
// Copyright (c) 1997, All rights reserved, by Micheal Hewett
//
// This software is free for educational and non-profit use.
// Any for-profit use must be governed by a license available
// from the author, who can be contacted via email at 
// "hewett@cs.stanford.edu"
//
// ===================================================================
//
//  Connection.java  - some description
//
//  12 Feb 1997
//
// -------------------------------------------------------------------

package lib.net;

import java.awt.*;
import java.io.*;
import java.net.*;

/**
 *  Class that handles all communication with the client.
 * @see java.lang.Thread
 * @author  Micheal S. Hewett    hewett@cs.utexas.edu
 * @date    Wed Feb 12 11:42:52 1997
 * @version 1.0
 *
 */
public class Connection extends Thread
{
  protected Socket          client;
  protected DataInputStream fromExternal;
  protected PrintStream     toExternal;

  // Initialize the streams and start the thread
  public Connection(Socket clientSocket)
  {
    client = clientSocket;

    try
    {
      fromExternal = new DataInputStream (client.getInputStream  ()); 
        toExternal = new PrintStream     (client.getOutputStream ()); 
    }
    catch (IOException e)
    {
      try  { client.close(); }
      catch (IOException e2) {};
      
      System.err.println ("lib.net.Connection: exception while getting socket stream: " + e);
      System.exit(1);
    };

    this.start();
  }


  /**
   * Process(line) processes the input line in some way.
   * The user should override the default behavior,
   * which is to echo the output to System.out.
   * 
   * @param String line
   * @return void
   * @author  Micheal S. Hewett    hewett@cs.utexas.edu
   * @date    Mon Feb 17 15:45:05 1997
   * @version 1.0
   * 
   */
  public void process(String line)
  {
    System.out.println(line);
  }

       
  public void send(String s)
  {
    toExternal.println(s);
    toExternal.flush();
  }

  public void run ()
  {
    char STOP = '\0';

    StringBuffer line;
    byte         ch;

    try
    {
      while (true)
      {
	line = new StringBuffer(80);

	// System.err.println("Connection: Reading a new line"); System.err.flush();
	while ((ch = fromExternal.readByte()) != STOP)
	{
	  line.append((char) ch);
	}
	line.append(STOP);

	// System.err.println("Connection: done reading a new line: " + line); System.err.flush();

	if (line.toString().substring(0, 5).equals(":QUIT"))
	{
	  System.err.println("\n;; Connection received :QUIT.");
	  break;
	}
	    
	process(line.toString());
      }
    }
    catch (IOException e)  // The LISP stream must have died.  No problem, just quit.
      { }
    catch (RuntimeException e)
      { System.err.println(";; Caught Runtime Exception..." + e + "\n");
        Thread.currentThread().dumpStack(); }
    finally
    {
      System.err.println(";; *** Connection shutting down...bye");
      System.err.flush();
      System.exit(0);
    }
  }
}
 
