/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.bevotest;

import java.lang.management.ManagementFactory;
import java.lang.management.ManagementPermission;
import java.lang.management.ThreadInfo;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyPermission;

public class BevoTest {
    public static final Permissions REQUESTED_PERMISSIONS = new Permissions();

    static {
        REQUESTED_PERMISSIONS.add(new PropertyPermission("java.class.path", "read"));
        REQUESTED_PERMISSIONS.add(new PropertyPermission("user.dir", "read"));
        REQUESTED_PERMISSIONS.add(new RuntimePermission("getStackTrace"));
        REQUESTED_PERMISSIONS.add(new RuntimePermission("stopThread"));
        REQUESTED_PERMISSIONS.add(new ManagementPermission("monitor"));
        REQUESTED_PERMISSIONS.setReadOnly();
    }

    private BevoTest() {
        throw new UnsupportedOperationException("Class BevoTest is not instantiable");
    }

    public static class NullTestItemException
    extends NullPointerException {
        public NullTestItemException(String s) {
            super(s);
        }
    }

    public static class Test
    implements Iterable<TestCase<?, ?>> {
        private String testName;
        private final List<TestCase<?, ?>> testCases;
        private final transient List<TestCase<?, ?>> testCasesReadOnly;

        public Test(String testName) {
            this.setTestName(testName);
            this.testCases = new ArrayList();
            this.testCasesReadOnly = Collections.unmodifiableList(this.testCases);
        }

        public String getTestName() {
            return this.testName;
        }

        protected void setTestName(String testName) {
            this.testName = testName;
        }

        public int size() {
            return this.testCasesReadOnly.size();
        }

        @Override
        public Iterator<TestCase<?, ?>> iterator() {
            return this.testCasesReadOnly.iterator();
        }

        protected void addTestCase(TestCase<?, ?> testCase) {
            this.testCases.add(testCase);
        }

        public void run(TestLog log) throws InterruptedException {
            try {
                for (TestCase<?, ?> testCase : this.testCases) {
                    testCase.run(log);
                }
            }
            finally {
                log.complete();
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Test [testName=\"").append(this.testName).append("\", testCases=").append(this.testCases).append("]");
            return builder.toString();
        }
    }

    public static abstract class TestCase<C, R> {
        private final Test test;
        private final Class<C> classUnderTest;
        private String description;
        private R expectedReturn;
        private Class<? extends Throwable> expectedThrowClass;
        private long timeOutMs;
        private static InheritableThreadLocal<TestExecutionResult<?, ?>> logEntryTL = new InheritableThreadLocal();

        protected TestCase(Test test, Class<C> classUnderTest, String description) {
            this.test = test;
            this.classUnderTest = classUnderTest;
            this.description = description;
            test.addTestCase(this);
        }

        public Test getTest() {
            return this.test;
        }

        public String getDescription() {
            return this.description;
        }

        protected void setDescription(String description) {
            this.description = description;
        }

        public Class<?> getClassUnderTest() {
            return this.classUnderTest;
        }

        public long getTimeOut() {
            return this.timeOutMs;
        }

        public R getExpectedReturn() {
            return this.expectedReturn;
        }

        public Class<? extends Throwable> getExpectedThrowClass() {
            return this.expectedThrowClass;
        }

        protected void setExpectedReturn(R expectedReturn) {
            this.expectedReturn = expectedReturn;
        }

        protected void setExpectedThrowClass(Class<? extends Throwable> expectedThrowClass) {
            this.expectedThrowClass = expectedThrowClass;
        }

        protected void setTimeOut(long timeOutMs) {
            this.timeOutMs = timeOutMs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(TestLog testLog) throws InterruptedException {
            final TestExecutionResult logEntry = new TestExecutionResult(testLog, this);
            if (Thread.interrupted()) {
                throw new InterruptedException("test run interrupted");
            }
            if (this.shouldSkip()) {
                logEntry.skipped();
                return;
            }
            ThreadGroup tg = new ThreadGroup("TestExecutionThreadGroup"){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof ThreadDeath)) {
                        try {
                            TestCase.this.caught(e, logEntry);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            tg.setDaemon(true);
            Thread t = new Thread(tg, "TestExecutionMainThread"){

                @Override
                public void run() {
                    try {
                        TestCase.this.initiate(logEntry);
                        try {
                            try {
                                TestCase.this.executeTest(logEntry);
                            }
                            catch (Throwable e1) {
                                if (!(e1 instanceof ThreadDeath)) {
                                    TestCase.this.caught(e1, logEntry);
                                }
                                TestCase.this.complete(logEntry);
                            }
                        }
                        finally {
                            TestCase.this.complete(logEntry);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            t.start();
            try {
                try {
                    long maxWait = System.currentTimeMillis() + this.getTimeOut();
                    while (tg.activeCount() > 0) {
                        if (System.currentTimeMillis() >= maxWait) {
                            return;
                        }
                        Thread.sleep(10L);
                    }
                    return;
                }
                catch (InterruptedException e) {
                    tg.interrupt();
                    throw e;
                }
            }
            finally {
                this.ensureThreadGroupTerminated(logEntry, tg, t);
            }
        }

        protected void ensureThreadGroupTerminated(TestExecutionResult<C, R> logEntry, ThreadGroup testThreadGroup, final Thread mainTestThread) throws InterruptedException {
            if (testThreadGroup.activeCount() > 0) {
                StackTraceElement[] stackTrace = null;
                try {
                    stackTrace = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                        @Override
                        public StackTraceElement[] run() {
                            return mainTestThread.getStackTrace();
                        }
                    });
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                if (this.hasActiveUserThreads(testThreadGroup)) {
                    this.timedOut(logEntry, stackTrace);
                }
                testThreadGroup.interrupt();
            }
            long maxWait = System.currentTimeMillis() + 120L;
            while (testThreadGroup.activeCount() > 0 && System.currentTimeMillis() < maxWait) {
                Thread.sleep(10L);
            }
            if (this.hasActiveUserThreads(testThreadGroup)) {
                System.err.println("BevoTest: WARNING: A test procedure execution has been forcibly terminated. This may leave an invalid state for subsequent tests.  Test case description: " + this.getDescription());
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ThreadInfo[] allThreadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                            int locksHeldCount = 0;
                            ThreadInfo[] threadInfoArray = allThreadInfos;
                            int n = allThreadInfos.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ThreadInfo ti = threadInfoArray[n2];
                                if (ti.getThreadId() == mainTestThread.getId()) {
                                    locksHeldCount += ti.getLockedMonitors().length;
                                    locksHeldCount += ti.getLockedSynchronizers().length;
                                }
                                ++n2;
                            }
                            if (locksHeldCount > 0) {
                                System.err.println("BevoTest: DANGER: The forcibly terminated procedure held " + locksHeldCount + " locks at time of termination.  Test case description: " + TestCase.this.getDescription());
                            }
                            return null;
                        }
                    });
                }
                catch (SecurityException securityException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                testThreadGroup.stop();
            }
            long maxWait2 = System.currentTimeMillis() + 500L;
            while (this.hasActiveUserThreads(testThreadGroup) && System.currentTimeMillis() < maxWait2) {
                Thread.sleep(10L);
            }
            if (!testThreadGroup.isDestroyed()) {
                Thread[] threadList = new Thread[testThreadGroup.activeCount() * 2];
                testThreadGroup.enumerate(threadList);
                Thread[] threadArray = threadList;
                int n = threadList.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread threadListElement = threadArray[n2];
                    if (threadListElement != null && !threadListElement.isAlive()) {
                        threadListElement.setDaemon(true);
                    }
                    ++n2;
                }
            }
        }

        protected boolean hasActiveUserThreads(ThreadGroup tg) {
            Thread[] threadList = new Thread[tg.activeCount() * 2];
            tg.enumerate(threadList);
            Thread[] threadArray = threadList;
            int n = threadList.length;
            int n2 = 0;
            while (n2 < n) {
                Thread threadListElement = threadArray[n2];
                if (threadListElement != null && !threadListElement.isDaemon() && threadListElement.isAlive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean shouldSkip() {
            return false;
        }

        protected void initiate(TestExecutionResult<C, R> logEntry) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException("test initiation interrupted");
            }
            logEntry.settingUp();
        }

        protected void executeTest(TestExecutionResult<C, R> logEntry) throws Throwable {
            logEntryTL.set(logEntry);
            this.executeTest();
        }

        protected abstract void executeTest() throws Throwable;

        protected void starting(C instanceUnderTest, TestExecutionResult<C, R> logEntry) {
            if (instanceUnderTest == null) {
                throw new NullTestItemException("Attempt to execute test on null test item");
            }
            logEntry.processing(instanceUnderTest);
        }

        protected void starting(C instanceUnderTest) {
            this.starting(instanceUnderTest, (TestExecutionResult)logEntryTL.get());
        }

        protected void startingStatic(Class<? extends C> actualClassUnderTest, TestExecutionResult<C, R> logEntry) {
            if (actualClassUnderTest == null) {
                throw new NullTestItemException("Attempt to execute test on null test class");
            }
            logEntry.processingStatic(actualClassUnderTest);
        }

        protected void startingStatic(Class<? extends C> actualClassUnderTest) {
            this.startingStatic(actualClassUnderTest, (TestExecutionResult)logEntryTL.get());
        }

        protected R returned(R value, TestExecutionResult<C, R> logEntry) {
            logEntry.returned(value);
            return value;
        }

        protected void returned(R value) {
            this.returned(value, (TestExecutionResult)logEntryTL.get());
        }

        protected void caught(Throwable t, TestExecutionResult<C, R> logEntry) throws InterruptedException {
            logEntry.caught(t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
        }

        protected void timedOut(TestExecutionResult<C, R> logEntry, StackTraceElement[] stackTrace) {
            logEntry.timedOut(stackTrace);
        }

        protected void complete(TestExecutionResult<C, R> logEntry) {
            logEntryTL.remove();
            logEntry.complete();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TestCase [test.name=\"").append(this.test.getTestName()).append("\", classUnderTest=").append(this.classUnderTest).append(", description=").append(this.description).append(", expectedReturn=").append(this.expectedReturn).append(", expectedThrowClass=").append(this.expectedThrowClass).append(", timeOutMs=").append(this.timeOutMs).append("]");
            return builder.toString();
        }
    }

    public static class TestExecutionResult<C, R>
    implements TestLogEntry {
        private final TestLog testLog;
        private final TestCase<C, R> testCase;
        private Status status;
        private Class<?> testItemClass;
        private R returnedValue;
        private boolean returnedValueValid;
        private Throwable caughtValue;
        private Evaluation evaluation;
        private long runTime;

        protected TestExecutionResult(TestLog testLog, TestCase<C, R> testCase) {
            this.testLog = testLog;
            this.testCase = testCase;
            this.status = Status.ENQUEUED;
            testLog.addEntry(this);
        }

        public TestLog getTestLog() {
            return this.testLog;
        }

        public TestCase<C, R> getTestCase() {
            return this.testCase;
        }

        public synchronized boolean isComplete() {
            return this.status == Status.COMPLETE_NORMAL || this.status == Status.COMPLETE_ABNORMAL || this.status == Status.TIMED_OUT;
        }

        public synchronized boolean isCompleteOrSkipped() {
            return this.isComplete() || this.status == Status.SKIPPED;
        }

        public synchronized Status getStatus() {
            return this.status;
        }

        protected synchronized void setStatus(Status status) {
            this.status = status;
            this.testLog.notifyEntryChanged(this);
        }

        public synchronized Class<?> getTestItemClass() {
            return this.testItemClass;
        }

        public synchronized boolean isReturnedValueValid() {
            return this.returnedValueValid;
        }

        public R getReturnedValue() throws IllegalStateException {
            if (!this.isReturnedValueValid()) {
                throw new IllegalStateException("ReturnedValue is not valid");
            }
            return this.returnedValue;
        }

        public synchronized Throwable getCaughtValue() {
            return this.caughtValue;
        }

        public synchronized Evaluation getEvaluation() throws IllegalStateException {
            if (!this.isCompleteOrSkipped()) {
                throw new IllegalStateException("status is not COMPLETE or SKIPPED; status=" + (Object)((Object)this.status));
            }
            return this.evaluation;
        }

        protected synchronized void setEvaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            this.testLog.notifyEntryChanged(this);
        }

        public synchronized long getRunTime() throws IllegalStateException {
            if (this.status != Status.COMPLETE_NORMAL) {
                throw new IllegalStateException("status is not COMPLETE_NORMAL; status=" + (Object)((Object)this.status));
            }
            return this.runTime;
        }

        protected void settingUp() throws IllegalStateException {
            if (this.status != Status.ENQUEUED) {
                throw new IllegalStateException("settingUp called when status=" + (Object)((Object)this.status));
            }
            this.setStatus(Status.RUNNING_SETUP);
        }

        protected void processing(C instanceUnderTest) throws IllegalStateException {
            this.processingStatic(instanceUnderTest.getClass());
        }

        protected void processingStatic(Class<?> classUnderTest) throws IllegalStateException {
            if (this.status != Status.RUNNING_SETUP) {
                throw new IllegalStateException("processing called when status=" + (Object)((Object)this.status));
            }
            this.testItemClass = classUnderTest;
            this.runTime = System.currentTimeMillis();
            this.setStatus(Status.RUNNING_PROCESSING);
        }

        protected void returned(R value) throws IllegalStateException {
            this.runTime = System.currentTimeMillis() - this.runTime;
            this.returnedValue = value;
            this.returnedValueValid = true;
            if (this.status != Status.RUNNING_PROCESSING) {
                throw new IllegalStateException("returned called when status=" + (Object)((Object)this.status));
            }
            this.tearingDown();
        }

        protected void tearingDown() throws IllegalStateException {
            if (this.status != Status.RUNNING_PROCESSING && this.status != Status.RUNNING_TEARDOWN) {
                throw new IllegalStateException("tearingDown called when status=" + (Object)((Object)this.status));
            }
            this.setStatus(Status.RUNNING_TEARDOWN);
        }

        protected void caught(Throwable t) {
            if (this.caughtValue == null) {
                this.caughtValue = t;
                this.setStatus(Status.COMPLETE_ABNORMAL);
            }
        }

        protected void timedOut(StackTraceElement[] stackTrace) {
            this.setStatus(Status.TIMED_OUT);
            if (stackTrace != null && stackTrace.length > 0) {
                this.caughtValue = new TimeoutStackTrace(stackTrace);
            }
        }

        protected synchronized void complete() throws IllegalStateException {
            if (this.status != Status.RUNNING_TEARDOWN && this.status != Status.COMPLETE_ABNORMAL && this.status != Status.TIMED_OUT) {
                throw new IllegalStateException("completing when status=" + (Object)((Object)this.status));
            }
            if (this.status == Status.TIMED_OUT) {
                this.setEvaluation(Evaluation.FAILED);
            } else {
                if (this.returnedValueValid) {
                    this.setStatus(Status.COMPLETE_NORMAL);
                    if (this.testCase.getExpectedThrowClass() == null && (this.testCase.getExpectedReturn() == null ? this.returnedValue == null : this.testCase.getExpectedReturn().equals(this.returnedValue))) {
                        this.setEvaluation(Evaluation.PASSED);
                    } else {
                        this.setEvaluation(Evaluation.FAILED);
                    }
                }
                if (this.caughtValue != null) {
                    this.setStatus(Status.COMPLETE_ABNORMAL);
                    if (this.testCase.getExpectedThrowClass() != null && this.caughtValue != null && this.testCase.getExpectedThrowClass().isAssignableFrom(this.caughtValue.getClass())) {
                        this.setEvaluation(Evaluation.PASSED);
                    } else {
                        this.setEvaluation(Evaluation.FAILED);
                    }
                }
            }
            assert (this.getEvaluation() != null) : "Evaluation was not set during test completion";
            assert (this.getEvaluation() != Evaluation.NO_RESULT) : "Evaluation was not set during test completion";
        }

        protected void skipped() {
            this.setStatus(Status.SKIPPED);
            this.setEvaluation(Evaluation.NO_RESULT);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TestExecutionResult [testCase=").append(this.testCase).append(", status=").append((Object)this.status).append(", testItemClass=").append(this.testItemClass).append(", returnedValue=").append(this.returnedValue).append(", returnedValueValid=").append(this.returnedValueValid).append(", caughtValue=").append(this.caughtValue).append(", evaluation=").append((Object)this.evaluation).append(", runTime=").append((double)this.runTime / 1000.0).append("]");
            return builder.toString();
        }

        public static enum Evaluation {
            NO_RESULT,
            FAILED,
            PASSED;

        }

        public static enum Status {
            ENQUEUED,
            RUNNING_SETUP,
            RUNNING_PROCESSING,
            RUNNING_TEARDOWN,
            SKIPPED,
            COMPLETE_NORMAL,
            COMPLETE_ABNORMAL,
            TIMED_OUT;

        }
    }

    public static class TestLog
    implements Iterable<TestLogEntry> {
        private final Test test;
        private final List<TestLogEntry> entries;
        private final transient List<TestLogEntry> entriesReadOnly;
        private final String environmentDescription;
        private final long testStartTime;
        private long testEndTime;

        public TestLog(Test test) {
            this.test = test;
            this.entries = new ArrayList<TestLogEntry>(test.size());
            this.entriesReadOnly = Collections.unmodifiableList(this.entries);
            this.environmentDescription = this.describeEnvironment();
            this.testStartTime = System.currentTimeMillis();
        }

        public Test getTest() {
            return this.test;
        }

        protected String describeEnvironment() {
            StringBuilder sb = new StringBuilder(80);
            sb.append("Java version ");
            sb.append(System.getProperty("java.version"));
            sb.append(", maximum heap size ");
            sb.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
            sb.append(" MB");
            sb.append(", running on ");
            sb.append(System.getProperty("os.name"));
            sb.append(" ");
            sb.append(System.getProperty("os.version"));
            sb.append(" (");
            sb.append(System.getProperty("os.arch"));
            sb.append(')');
            try {
                String java_class_path = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("java.class.path");
                    }
                });
                sb.append("\nJava class path:   ");
                sb.append(java_class_path);
            }
            catch (AccessControlException java_class_path) {
                // empty catch block
            }
            try {
                String user_dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("user.dir");
                    }
                });
                sb.append("\nWorking directory: ");
                sb.append(user_dir);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            return sb.toString();
        }

        public String getEnvironmentDescription() {
            return this.environmentDescription;
        }

        public long getTestStartTime() {
            return this.testStartTime;
        }

        public synchronized long getTestEndTime() {
            return this.testEndTime;
        }

        public synchronized int size() {
            return this.entries.size();
        }

        @Override
        public synchronized Iterator<TestLogEntry> iterator() {
            return this.entriesReadOnly.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addEntry(TestLogEntry logEntry) throws IllegalStateException {
            TestLog testLog = this;
            synchronized (testLog) {
                if (this.testEndTime != 0L) {
                    throw new IllegalStateException("TestLog is already complete");
                }
                this.entries.add(logEntry);
            }
            this.notifyNewEntry(logEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() throws IllegalStateException {
            TestLog testLog = this;
            synchronized (testLog) {
                if (this.testEndTime != 0L) {
                    throw new IllegalStateException("TestLog is already complete");
                }
                this.testEndTime = System.currentTimeMillis();
            }
            this.notifyComplete();
        }

        protected void notifyNewEntry(TestLogEntry entry) {
        }

        protected void notifyEntryChanged(TestLogEntry entry) {
        }

        protected void notifyComplete() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TestLog [test=\"").append(this.test.getTestName()).append("\", entries=").append(this.entries).append(", environmentDescription=").append(this.environmentDescription).append(", testStartTime=").append(TestLog.formatTime(this.testStartTime)).append(", testEndTime=").append(TestLog.formatTime(this.testEndTime)).append("]");
            return builder.toString();
        }

        protected static String formatTime(long timeMs) {
            return String.format("%1$TF %1$TT %1$TZ", timeMs);
        }
    }

    public static interface TestLogEntry {
    }

    public static abstract class TestReturns<C, R>
    extends TestCase<C, R> {
        public TestReturns(Test test, Class<C> classUnderTest, String description, R expectedReturn) {
            super(test, classUnderTest, description);
            this.setExpectedReturn(expectedReturn);
        }

        public TestReturns(Test test, Class<C> classUnderTest, String description, R expectedReturn, long timeOutMs) {
            super(test, classUnderTest, description);
            this.setExpectedReturn(expectedReturn);
            this.setTimeOut(timeOutMs);
        }
    }

    public static abstract class TestThrows<C, R>
    extends TestCase<C, R> {
        public TestThrows(Test test, Class<C> classUnderTest, String description, Class<? extends Throwable> expectedThrowClass) {
            super(test, classUnderTest, description);
            this.setExpectedThrowClass(expectedThrowClass);
        }

        public TestThrows(Test test, Class<C> classUnderTest, String description, Class<? extends Throwable> expectedThrowClass, long timeOutMs) {
            super(test, classUnderTest, description);
            this.setExpectedThrowClass(expectedThrowClass);
            this.setTimeOut(timeOutMs);
        }
    }

    public static class TimeoutStackTrace
    extends Throwable {
        protected TimeoutStackTrace(StackTraceElement[] stackTrace) {
            super("Stack trace at time out");
            this.setStackTrace(stackTrace);
        }

        @Override
        public String toString() {
            return "Stack trace at time out:";
        }
    }
}

