/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.bevotest;

import edu.utexas.cs.bevotest.BevoTest;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class PlaintextTestReporter {
    private final BevoTest.TestLog log;
    private static final String newLine = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    public static final Permissions REQUESTED_PERMISSIONS = new Permissions();

    static {
        REQUESTED_PERMISSIONS.add(new RuntimePermission("accessDeclaredMembers"));
        REQUESTED_PERMISSIONS.add(new RuntimePermission("getProtectionDomain"));
        REQUESTED_PERMISSIONS.setReadOnly();
    }

    public PlaintextTestReporter(BevoTest.TestLog log) {
        this.log = log;
    }

    public void report(Appendable out) throws IOException {
        this.report(out, ReportOption.EMPTY_SET);
    }

    public void report(Appendable out, Set<ReportOption> reportOpts) throws IOException {
        this.reportHeader(out, reportOpts);
        int logEntryCount = 0;
        String entryNumFormat = "%" + String.valueOf(this.log.size()).length() + "d";
        for (BevoTest.TestLogEntry entry : this.log) {
            if (reportOpts.contains((Object)ReportOption.ONE_LINE) || reportOpts.contains((Object)ReportOption.ONE_LINE_SHOW_STACK)) {
                out.append(String.format(entryNumFormat, new Integer(++logEntryCount))).append(" | ");
            } else {
                out.append(newLine);
                out.append("TEST LOG ENTRY ").append(String.valueOf(++logEntryCount)).append(newLine);
            }
            this.reportEntry(entry, out, reportOpts);
        }
        this.reportFooter(out, reportOpts);
    }

    public void reportSummary(Appendable out, Set<ReportOption> reportOpts) throws IOException {
        HashMap testedClasses = new HashMap();
        int[] overallEvals = new int[BevoTest.TestExecutionResult.Evaluation.values().length];
        HashMap testedClassEvals = new HashMap<Class<?>, int[]>(){

            @Override
            public int[] get(Object key) {
                int[] v = (int[])super.get(key);
                if (v == null) {
                    v = new int[BevoTest.TestExecutionResult.Evaluation.values().length];
                }
                return v;
            }
        };
        for (BevoTest.TestLogEntry entry : this.log) {
            if (!(entry instanceof BevoTest.TestExecutionResult)) continue;
            BevoTest.TestExecutionResult result = (BevoTest.TestExecutionResult)entry;
            Class<?> tic = result.getTestItemClass();
            if (tic != null) {
                if (!testedClasses.containsKey(tic)) {
                    testedClasses.put(tic, PlaintextTestReporter.describeClass(result.getTestItemClass(), true));
                }
                int[] evals = (int[])testedClassEvals.get(tic);
                if (result.getEvaluation() != null) {
                    int n = result.getEvaluation().ordinal();
                    evals[n] = evals[n] + 1;
                }
            }
            if (result.getEvaluation() != null) {
                int n = result.getEvaluation().ordinal();
                overallEvals[n] = overallEvals[n] + 1;
                continue;
            }
            System.err.println("BevoTest: WARNING: Test result without evaluation not counted. Test case description: " + result.getTestCase().getDescription());
        }
        out.append("TEST SUMMARY").append(newLine);
        out.append(newLine);
        out.append("Test name: ").append(this.log.getTest().getTestName()).append(newLine);
        out.append(newLine);
        out.append("Results: ");
        int ord = BevoTest.TestExecutionResult.Evaluation.values().length - 1;
        while (ord >= 0) {
            BevoTest.TestExecutionResult.Evaluation evalType = BevoTest.TestExecutionResult.Evaluation.values()[ord];
            out.append(PlaintextTestReporter.formatEnum(evalType));
            out.append(": ");
            out.append(String.valueOf(overallEvals[evalType.ordinal()]));
            if (ord > 0) {
                out.append(", ");
            }
            --ord;
        }
        out.append(newLine);
        out.append(newLine);
        out.append("Classes tested:").append(newLine);
        for (String testedClassDescr : testedClasses.values()) {
            out.append("* ").append(testedClassDescr).append(newLine);
        }
        out.append(newLine);
        out.append("Environment:       ").append(this.log.getEnvironmentDescription()).append(newLine);
        out.append("Test start time:   ").append(PlaintextTestReporter.formatTime(this.log.getTestStartTime())).append(newLine);
        out.append("Test end time:     ").append(PlaintextTestReporter.formatTime(this.log.getTestEndTime())).append(newLine);
        out.append("Test elapsed time: ").append(PlaintextTestReporter.formatDuration(this.log.getTestEndTime() - this.log.getTestStartTime())).append(newLine);
    }

    protected void reportHeader(Appendable out, Set<ReportOption> reportOpts) throws IOException {
        this.reportSummary(out, reportOpts);
        out.append(newLine).append(newLine).append("TEST LOG").append(newLine);
    }

    protected void reportFooter(Appendable out, Set<ReportOption> reportOpts) throws IOException {
        out.append(newLine).append("END OF TEST LOG").append(newLine);
    }

    public void reportCase(BevoTest.TestCase<?, ?> testCase, Appendable out, Set<ReportOption> reportOpts) throws IOException {
        out.append("   Test case description:   ").append(testCase.getDescription()).append(newLine);
        out.append("   Declared test item type: ").append(PlaintextTestReporter.describeClass(testCase.getClassUnderTest(), false)).append(newLine);
        if (testCase.getExpectedThrowClass() == null) {
            if (testCase.getExpectedReturn() == null) {
                out.append("   Expected return value:   null").append(newLine);
            } else if (!reportOpts.contains((Object)ReportOption.NO_VALUES)) {
                out.append("   Expected return value:   ").append(testCase.getExpectedReturn().getClass().getCanonicalName()).append(": ").append(testCase.getExpectedReturn().toString()).append(newLine);
            } else {
                out.append("   Expected return type:    ").append(testCase.getExpectedReturn().getClass().getCanonicalName()).append(newLine);
            }
        } else {
            out.append("   Expected thrown class:   ").append(PlaintextTestReporter.describeClass(testCase.getExpectedThrowClass(), false)).append(newLine);
        }
        if (testCase.getTimeOut() > 0L) {
            out.append("   Time out:                ").append(String.valueOf(testCase.getTimeOut())).append(" ms").append(newLine);
        }
    }

    public void reportEntry(BevoTest.TestLogEntry entry, Appendable out, Set<ReportOption> reportOpts) throws IOException {
        if (entry instanceof BevoTest.TestExecutionResult) {
            this.reportEntry((BevoTest.TestExecutionResult)entry, out, reportOpts);
        } else {
            out.append("Unknown entry type:").append(newLine);
            out.append("    ");
            out.append(entry.toString());
            out.append(newLine);
        }
    }

    public void reportEntry(BevoTest.TestExecutionResult<?, ?> entry, Appendable out, Set<ReportOption> reportOpts) throws IOException {
        if (reportOpts.contains((Object)ReportOption.ONE_LINE) || reportOpts.contains((Object)ReportOption.ONE_LINE_SHOW_STACK)) {
            String eval = entry.isCompleteOrSkipped() ? PlaintextTestReporter.formatEnum(entry.getEvaluation()) : "";
            out.append((String.valueOf(eval) + "         ").substring(0, 9)).append(" | ");
            StringBuilder statusColumn = new StringBuilder(24);
            if (entry.getStatus() == BevoTest.TestExecutionResult.Status.COMPLETE_NORMAL && entry.getEvaluation() == BevoTest.TestExecutionResult.Evaluation.PASSED) {
                statusColumn.append("Run time: ");
                statusColumn.append(entry.getRunTime());
                statusColumn.append(" ms");
            } else if (entry.getStatus() == BevoTest.TestExecutionResult.Status.COMPLETE_NORMAL && entry.getEvaluation() == BevoTest.TestExecutionResult.Evaluation.FAILED) {
                statusColumn.append("Incorrect return value");
            } else if (entry.getStatus() == BevoTest.TestExecutionResult.Status.COMPLETE_ABNORMAL && entry.getCaughtValue() != null) {
                statusColumn.append(entry.getCaughtValue().getClass().getSimpleName());
            } else if (entry.getStatus() == BevoTest.TestExecutionResult.Status.TIMED_OUT) {
                statusColumn.append(PlaintextTestReporter.formatEnum(entry.getStatus()));
                statusColumn.append(" > ");
                statusColumn.append(entry.getTestCase().getTimeOut());
                statusColumn.append(" ms");
            } else {
                statusColumn.append(PlaintextTestReporter.formatEnum(entry.getStatus()));
            }
            out.append((statusColumn + "                        ").substring(0, 24)).append(" | ");
            out.append(entry.getTestCase().getDescription()).append(newLine);
            if (entry.getCaughtValue() != null && !(entry.getCaughtValue() instanceof BevoTest.NullTestItemException) && entry.getEvaluation() != BevoTest.TestExecutionResult.Evaluation.PASSED && reportOpts.contains((Object)ReportOption.ONE_LINE_SHOW_STACK)) {
                out.append("      ");
                this.appendStackTrace(entry.getCaughtValue(), out);
            }
        } else {
            boolean showDetail;
            out.append("Test case:").append(newLine);
            this.reportCase(entry.getTestCase(), out, reportOpts);
            out.append("Test procedure result:").append(newLine);
            boolean bl = showDetail = !reportOpts.contains((Object)ReportOption.FAIL_DETAIL_ONLY) || entry.getEvaluation() == BevoTest.TestExecutionResult.Evaluation.FAILED;
            if (entry.getTestItemClass() != null && showDetail) {
                out.append("   Actual test item type:   ").append(PlaintextTestReporter.describeClass(entry.getTestItemClass(), false)).append(newLine);
            }
            out.append("   Test procedure status:   ").append(entry.getStatus().toString()).append(newLine);
            if (entry.isReturnedValueValid() && showDetail) {
                if (entry.getReturnedValue() == null) {
                    out.append("   Actual return value:     null").append(newLine);
                } else if (!reportOpts.contains((Object)ReportOption.NO_VALUES)) {
                    out.append("   Actual return value:     ").append(entry.getReturnedValue().getClass().getCanonicalName()).append(": ").append(entry.getReturnedValue().toString()).append(newLine);
                } else {
                    out.append("   Actual return type:      ").append(entry.getReturnedValue().getClass().getCanonicalName()).append(newLine);
                }
            }
            if (entry.getCaughtValue() != null && showDetail) {
                if (!(entry.getCaughtValue() instanceof BevoTest.TimeoutStackTrace)) {
                    out.append("   Thrown value:            ");
                } else {
                    out.append("   ");
                }
                this.appendStackTrace(entry.getCaughtValue(), out);
            }
            if (entry.getStatus() == BevoTest.TestExecutionResult.Status.COMPLETE_NORMAL) {
                out.append("   Test procedure run time: ").append(String.valueOf(entry.getRunTime())).append(" ms").append(newLine);
            }
            out.append("   Evaluation:              ").append(entry.getEvaluation() != null ? entry.getEvaluation().toString() : "[unevaluated]").append(newLine);
        }
    }

    protected static String formatEnum(Enum<?> enumVal) {
        if (enumVal == null) {
            return "[null]";
        }
        String s = enumVal.toString().replace('_', ' ');
        return String.valueOf(s.charAt(0)) + s.toLowerCase().substring(1);
    }

    protected static String formatTime(long timeMs) {
        return String.format("%1$TF %1$TT %1$TZ", timeMs);
    }

    protected static String formatDuration(long durationMs) {
        return String.format("%d.%03d s", durationMs / 1000L, durationMs % 1000L);
    }

    protected static String describeClass(final Class<?> clazz, boolean detailed) {
        if (clazz == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(clazz.isInterface() ? "interface " : (clazz.isPrimitive() ? "" : "class "));
        if (clazz.getCanonicalName() != null) {
            out.append(clazz.getCanonicalName());
        } else {
            out.append("{anonymous class ");
            out.append(clazz.getName());
            if (detailed) {
                try {
                    Method method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                        @Override
                        public Method run() {
                            return clazz.getEnclosingMethod();
                        }
                    });
                    out.append(" in ");
                    out.append(method.toString());
                }
                catch (AccessControlException method) {
                }
                catch (NullPointerException method) {
                    // empty catch block
                }
            }
            out.append('}');
        }
        if (detailed) {
            try {
                URL location = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        return clazz.getProtectionDomain().getCodeSource().getLocation();
                    }
                });
                out.append(", loaded from ");
                out.append(location.toString());
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return out.toString();
    }

    protected void appendStackTrace(Throwable t, Appendable out) throws IOException {
        Throwable cause;
        String ourName = BevoTest.TestCase.class.getName().split("\\$")[0];
        StackTraceElement[] trace = t.getStackTrace();
        int endTrace = trace.length;
        int frameNum = trace.length - 1;
        int foundOurself = -1;
        while (frameNum >= 0) {
            if (trace[frameNum].getClassName().startsWith(ourName)) {
                foundOurself = frameNum;
            } else if (foundOurself != -1) {
                endTrace = foundOurself;
                break;
            }
            --frameNum;
        }
        out.append(t.toString()).append(newLine);
        frameNum = 0;
        while (frameNum < endTrace) {
            out.append("\tat ").append(trace[frameNum].toString()).append(newLine);
            ++frameNum;
        }
        if (endTrace < trace.length) {
            out.append("\t... ").append(String.valueOf(trace.length - endTrace)).append(" more").append(newLine);
        }
        if ((cause = t.getCause()) != null) {
            this.appendStackTraceAsCause(cause, out, trace);
        }
    }

    private void appendStackTraceAsCause(Throwable cause, Appendable out, StackTraceElement[] causedTrace) throws IOException {
        Throwable ourCause;
        StackTraceElement[] trace = cause.getStackTrace();
        int m = trace.length - 1;
        int n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            --m;
            --n;
        }
        int framesInCommon = trace.length - 1 - m;
        out.append("Caused by: ").append(cause.toString()).append(newLine);
        int i = 0;
        while (i <= m) {
            out.append("\tat ").append(trace[i].toString()).append(newLine);
            ++i;
        }
        if (framesInCommon != 0) {
            out.append("\t... ").append(String.valueOf(framesInCommon)).append(" more").append(newLine);
        }
        if ((ourCause = cause.getCause()) != null) {
            this.appendStackTraceAsCause(ourCause, out, trace);
        }
    }

    public static enum ReportOption {
        ONE_LINE,
        FAIL_DETAIL_ONLY,
        NO_VALUES,
        ONE_LINE_SHOW_STACK;

        public static final Set<ReportOption> EMPTY_SET;

        static {
            EMPTY_SET = EnumSet.noneOf(ReportOption.class);
        }

        public static Set<ReportOption> setOf(ReportOption e) {
            return EnumSet.of(e);
        }

        public static Set<ReportOption> setOf(ReportOption e1, ReportOption e2) {
            return EnumSet.of(e1, e2);
        }

        public static Set<ReportOption> setOf(ReportOption e1, ReportOption e2, ReportOption e3) {
            return EnumSet.of(e1, e2, e3);
        }

        public static Set<ReportOption> setOf(ReportOption e1, ReportOption e2, ReportOption e3, ReportOption e4) {
            return EnumSet.of(e1, e2, e3, e4);
        }

        public static Set<ReportOption> setOf(ReportOption e1, ReportOption e2, ReportOption e3, ReportOption e4, ReportOption e5) {
            return EnumSet.of(e1, e2, e3, e4, e5);
        }

        public static Set<ReportOption> setOf(ReportOption first, ReportOption ... rest) {
            return EnumSet.of(first, rest);
        }
    }
}

