/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PGraphics;
import processing.core.PShape;
import processing.core.PShapeOBJ;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShapeOpenGL;

public class PGraphics3D
extends PGraphicsOpenGL {
    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    protected void defaultCamera() {
        this.camera();
    }

    @Override
    protected void begin2D() {
        this.pushProjection();
        this.ortho((float)(-this.width) / 2.0f, (float)this.width / 2.0f, (float)(-this.height) / 2.0f, (float)this.height / 2.0f);
        this.pushMatrix();
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        this.modelview.reset();
        this.modelview.translate(-centerX, -centerY);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    protected void end2D() {
        this.popMatrix();
        this.popProjection();
    }

    protected static boolean isSupportedExtension(String extension) {
        return extension.equals("obj");
    }

    protected static PShape loadShapeImpl(PGraphics pg, String filename, String extension) {
        PShapeOBJ obj = null;
        if (extension.equals("obj")) {
            obj = new PShapeOBJ(pg.parent, filename);
            int prevTextureMode = pg.textureMode;
            pg.textureMode = 1;
            PShapeOpenGL p3d = PShapeOpenGL.createShape((PGraphicsOpenGL)pg, (PShape)obj);
            pg.textureMode = prevTextureMode;
            return p3d;
        }
        return null;
    }
}

