/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicMarkableReference;
import sun.util.resources.OpenListResourceBundle;

public abstract class ParallelListResourceBundle
extends ResourceBundle {
    private volatile ConcurrentMap<String, Object> lookup;
    private volatile Set<String> keyset;
    private final AtomicMarkableReference<Object[][]> parallelContents = new AtomicMarkableReference<Object>(null, false);

    protected ParallelListResourceBundle() {
    }

    protected abstract Object[][] getContents();

    ResourceBundle getParent() {
        return this.parent;
    }

    public void setParallelContents(OpenListResourceBundle openListResourceBundle) {
        if (openListResourceBundle == null) {
            this.parallelContents.compareAndSet(null, null, false, true);
        } else {
            this.parallelContents.compareAndSet(null, openListResourceBundle.getContents(), false, false);
        }
    }

    boolean areParallelContentsComplete() {
        if (this.parallelContents.isMarked()) {
            return true;
        }
        boolean[] blArray = new boolean[1];
        Object[][] objectArray = this.parallelContents.get(blArray);
        return objectArray != null || blArray[0];
    }

    @Override
    protected Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public boolean containsKey(String string) {
        return this.keySet().contains(string);
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        KeySet keySet;
        while ((keySet = this.keyset) == null) {
            keySet = new KeySet(this.handleKeySet(), this.parent);
            ParallelListResourceBundle parallelListResourceBundle = this;
            synchronized (parallelListResourceBundle) {
                if (this.keyset == null) {
                    this.keyset = keySet;
                }
            }
        }
        return keySet;
    }

    synchronized void resetKeySet() {
        this.keyset = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadLookupTablesIfNecessary() {
        Object[][] objectArray;
        ConcurrentMap<String, Object> concurrentMap = this.lookup;
        if (concurrentMap == null) {
            concurrentMap = new ConcurrentHashMap<String, Object>();
            objectArray = this.getContents();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = objectArray[i];
                concurrentMap.put((String)objectArray2[0], objectArray2[1]);
            }
        }
        if ((objectArray = this.parallelContents.getReference()) != null) {
            for (Object[] objectArray3 : objectArray) {
                concurrentMap.putIfAbsent((String)objectArray3[0], objectArray3[1]);
            }
            this.parallelContents.set(null, true);
        }
        if (this.lookup == null) {
            ParallelListResourceBundle parallelListResourceBundle = this;
            synchronized (parallelListResourceBundle) {
                if (this.lookup == null) {
                    this.lookup = concurrentMap;
                }
            }
        }
    }

    private static class KeySet
    extends AbstractSet<String> {
        private final Set<String> set;
        private final ResourceBundle parent;

        private KeySet(Set<String> set, ResourceBundle resourceBundle) {
            this.set = set;
            this.parent = resourceBundle;
        }

        @Override
        public boolean contains(Object object) {
            if (this.set.contains(object)) {
                return true;
            }
            return this.parent != null ? this.parent.containsKey((String)object) : false;
        }

        @Override
        public Iterator<String> iterator() {
            if (this.parent == null) {
                return this.set.iterator();
            }
            return new Iterator<String>(){
                private Iterator<String> itr;
                private boolean usingParent;
                {
                    this.itr = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.itr.hasNext()) {
                        return true;
                    }
                    if (!this.usingParent) {
                        HashSet<String> hashSet = new HashSet<String>(parent.keySet());
                        hashSet.removeAll(set);
                        this.itr = hashSet.iterator();
                        this.usingParent = true;
                    }
                    return this.itr.hasNext();
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        return this.itr.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.parent == null) {
                return this.set.size();
            }
            HashSet<String> hashSet = new HashSet<String>(this.set);
            hashSet.addAll(this.parent.keySet());
            return hashSet.size();
        }
    }
}

