/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class SqrOsc
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_freq = 440.0f;
    private float m_amp = 0.5f;
    private float m_add = 0.0f;
    private float m_pos = 0.0f;
    private int m_panBusId;

    public SqrOsc(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        SqrOsc sqrOsc = this;
        sqrOsc.m_engine.start();
        SqrOsc sqrOsc2 = this;
        this.m_panBusId = sqrOsc2.m_engine.busConstructMono();
    }

    public void play() {
        this.m_nodeId = Engine.sqrPlay(this.m_freq, this.m_amp, this.m_add - 1.0f, this.m_pos, this.m_panBusId);
    }

    public void play(float f, float f2, float f3, float f4) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.m_pos = f4;
        this.play();
    }

    public void play(float f, float f2, float f3) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.play();
    }

    public void play(float f, float f2) {
        this.m_freq = f;
        this.m_amp = f2;
        this.play();
    }

    public void play(float f) {
        this.m_freq = f;
        this.play();
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.sqrSet(this.m_freq, this.m_amp, this.m_add - 1.0f, this.m_pos, this.m_nodeId);
        }
    }

    public void set(float f, float f2, float f3, float f4) {
        this.m_freq = f;
        this.m_amp = f2;
        this.m_add = f3;
        this.m_pos = f4;
        this.set();
    }

    public void freq(float f) {
        this.m_freq = f;
        this.set();
    }

    public void amp(float f) {
        this.m_amp = f;
        this.set();
    }

    public void add(float f) {
        this.m_add = f;
        this.set();
    }

    public void pan(float f) {
        this.m_pos = f;
        this.set();
    }

    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

