/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;
import net.java.games.input.DirectInputEnvironmentPlugin;
import net.java.games.input.LinuxEnvironmentPlugin;
import net.java.games.input.OSXEnvironmentPlugin;

public abstract class ControllerEnvironment {
    protected static final byte MACOSX = 0;
    protected static final byte WINDOWS = 1;
    protected static final byte LINUX = 2;
    protected static final byte OTHER = 3;
    protected static final byte os = ControllerEnvironment.getOS();
    protected static final byte wordsize = ControllerEnvironment.getWordSize();
    protected final ArrayList controllerListeners = new ArrayList();
    private static ControllerEnvironment instance;

    static void logln(String string) {
        ControllerEnvironment.log(string + "\n");
    }

    static void log(String string) {
        System.out.print(string);
    }

    protected ControllerEnvironment() {
    }

    private static byte getOS() {
        String string = System.getProperty("os.name");
        if (string.toLowerCase().indexOf("mac") != -1) {
            return 0;
        }
        if (string.indexOf("Windows") != -1) {
            return 1;
        }
        if (string.equals("Linux")) {
            return 2;
        }
        return 3;
    }

    private static byte getWordSize() {
        String string = System.getProperty("sun.arch.data.model");
        if (string.indexOf("32") != -1) {
            return 32;
        }
        if (string.indexOf("64") != -1) {
            return 64;
        }
        return 0;
    }

    public abstract Controller[] getControllers();

    public void addControllerListener(ControllerListener controllerListener) {
        if (controllerListener != null) {
            this.controllerListeners.add(controllerListener);
        }
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (controllerListener != null) {
            this.controllerListeners.remove(controllerListener);
        }
    }

    protected void fireControllerAdded(Controller controller) {
        System.out.println("Added");
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator iterator = this.controllerListeners.iterator();
        while (iterator.hasNext()) {
            ((ControllerListener)iterator.next()).controllerAdded(controllerEvent);
        }
    }

    protected void fireControllerRemoved(Controller controller) {
        System.out.println("REMOVED");
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator iterator = this.controllerListeners.iterator();
        while (iterator.hasNext()) {
            ((ControllerListener)iterator.next()).controllerRemoved(controllerEvent);
        }
    }

    public static ControllerEnvironment getEnvironment() {
        if (instance == null) {
            switch (os) {
                case 1: {
                    instance = new DirectInputEnvironmentPlugin();
                    break;
                }
                case 2: {
                    instance = new LinuxEnvironmentPlugin();
                    break;
                }
                case 0: {
                    instance = new OSXEnvironmentPlugin();
                    break;
                }
                default: {
                    throw new RuntimeException("Your operating system is not supported");
                }
            }
        }
        return instance;
    }
}

