/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.RawDevice;
import net.java.games.input.RawDeviceInfo;
import net.java.games.input.RawInputEventQueue;
import net.java.games.input.SetupAPIDevice;

public final class RawInputEnvironmentPlugin
extends ControllerEnvironment {
    private final Controller[] controllers;

    public static boolean isSupported() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public RawInputEnvironmentPlugin() {
        Controller[] controllerArray = new Controller[]{};
        try {
            RawInputEventQueue rawInputEventQueue = new RawInputEventQueue();
            controllerArray = this.enumControllers(rawInputEventQueue);
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln("Failed to enumerate devices: " + iOException.getMessage());
        }
        this.controllers = controllerArray;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private static final SetupAPIDevice lookupSetupAPIDevice(String string, List list) {
        string = string.replaceAll("#", "\\\\").toUpperCase();
        for (int i = 0; i < list.size(); ++i) {
            SetupAPIDevice setupAPIDevice = (SetupAPIDevice)list.get(i);
            if (string.indexOf(setupAPIDevice.getInstanceId().toUpperCase()) == -1) continue;
            return setupAPIDevice;
        }
        return null;
    }

    private static final void createControllersFromDevices(RawInputEventQueue rawInputEventQueue, List list, List list2, List list3) throws IOException {
        ArrayList<RawDevice> arrayList = new ArrayList<RawDevice>();
        for (int i = 0; i < list2.size(); ++i) {
            RawDeviceInfo rawDeviceInfo;
            Controller controller;
            RawDevice rawDevice = (RawDevice)list2.get(i);
            SetupAPIDevice setupAPIDevice = RawInputEnvironmentPlugin.lookupSetupAPIDevice(rawDevice.getName(), list3);
            if (setupAPIDevice == null || (controller = (rawDeviceInfo = rawDevice.getInfo()).createControllerFromDevice(rawDevice, setupAPIDevice)) == null) continue;
            list.add(controller);
            arrayList.add(rawDevice);
        }
        rawInputEventQueue.start(arrayList);
    }

    private static final native void enumerateDevices(RawInputEventQueue var0, List var1) throws IOException;

    private final Controller[] enumControllers(RawInputEventQueue rawInputEventQueue) throws IOException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        RawInputEnvironmentPlugin.enumerateDevices(rawInputEventQueue, arrayList2);
        List list = RawInputEnvironmentPlugin.enumSetupAPIDevices();
        RawInputEnvironmentPlugin.createControllersFromDevices(rawInputEventQueue, arrayList, arrayList2, list);
        Controller[] controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    private static final List enumSetupAPIDevices() throws IOException {
        ArrayList arrayList = new ArrayList();
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getKeyboardClassGUID(), arrayList);
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getMouseClassGUID(), arrayList);
        return arrayList;
    }

    private static final native void nEnumSetupAPIDevices(byte[] var0, List var1) throws IOException;

    private static final native byte[] getKeyboardClassGUID();

    private static final native byte[] getMouseClassGUID();

    static {
        if (RawInputEnvironmentPlugin.isSupported()) {
            System.loadLibrary("jinput-raw");
        }
    }
}

