/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.io.File;
import java.util.ArrayList;
import org.gamecontrolplus.PCPconstants;
import processing.core.PApplet;

public class Configuration
implements PCPconstants {
    public static final int ECLIPSE = 0;
    public static final int PROCESSING = 1;
    public static int IDE = 1;
    final String filename;
    final String usage;
    final InputConfig[] gameInputs;

    public static Configuration makeConfiguration(PApplet pApplet, String string) {
        File file = IDE == 0 ? new File(string) : new File(pApplet.dataPath("") + "/" + string);
        String[] stringArray = PApplet.loadStrings((File)file);
        if (stringArray == null) {
            System.out.println("Unable to find configuration file " + string);
            return null;
        }
        return new Configuration(pApplet, stringArray, string);
    }

    public static void saveConfiguration(PApplet pApplet, Configuration configuration) {
        String[] stringArray = new String[configuration.gameInputs.length + 1];
        int n = 0;
        stringArray[n++] = configuration.usage;
        for (InputConfig inputConfig : configuration.gameInputs) {
            stringArray[n++] = inputConfig.toString();
        }
        File file = IDE == 0 ? new File(configuration.filename) : new File(pApplet.dataPath("") + "/" + configuration.filename);
        PApplet.saveStrings((File)file, (String[])stringArray);
    }

    private Configuration(PApplet pApplet, String[] stringArray, String string) {
        ArrayList<InputConfig> arrayList = new ArrayList<InputConfig>();
        this.filename = string;
        this.usage = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            arrayList.add(new InputConfig(stringArray[i]));
        }
        this.gameInputs = arrayList.toArray(new InputConfig[arrayList.size()]);
    }

    public String getUsgae() {
        return this.usage;
    }

    public InputConfig[] getGameInputs() {
        return this.gameInputs;
    }

    public int nbrInputs() {
        return this.gameInputs.length;
    }

    public class InputConfig {
        public String key;
        public String description;
        public int type;
        public String typeName;
        public String deviceInputName;
        public int inputConNo;
        public float multiplier = 1.0f;
        public float tolerance = 0.0f;

        public InputConfig(String string) {
            String[] stringArray = PApplet.split((String)string, (String)"\t");
            this.key = stringArray[0];
            this.description = stringArray[1];
            this.type = Integer.parseInt(stringArray[2]);
            this.typeName = stringArray[3];
            this.deviceInputName = stringArray[4];
            this.inputConNo = Integer.parseInt(stringArray[5]);
            if (stringArray.length > 6) {
                this.multiplier = Float.parseFloat(stringArray[6]);
            }
            if (stringArray.length > 7) {
                this.tolerance = Float.parseFloat(stringArray[7]);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.key + "\t");
            stringBuilder.append(this.description + "\t");
            stringBuilder.append(this.type + "\t");
            stringBuilder.append(this.typeName + "\t");
            stringBuilder.append(this.deviceInputName + "\t");
            stringBuilder.append(this.inputConNo + "\t");
            stringBuilder.append(this.multiplier + "\t");
            stringBuilder.append(this.tolerance);
            return stringBuilder.toString();
        }
    }
}

