/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.ControlRelativeSlider;
import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.PCPconstants;
import processing.core.PApplet;

public class ControlDevice
implements Comparable<ControlDevice>,
PCPconstants {
    private final Controller controller;
    private final PApplet parent;
    public boolean available = true;
    private final List<ControlSlider> sliders = new ArrayList<ControlSlider>();
    private final List<ControlButton> buttons = new ArrayList<ControlButton>();
    private Rumbler[] rumblers = new Rumbler[0];
    private final Map<String, ControlInput> inputNameMap = new HashMap<String, ControlInput>();
    private final List<ControlInput> inputs = new ArrayList<ControlInput>();
    private boolean open = false;
    private final String name;

    ControlDevice(Controller controller, PApplet pApplet) {
        this.controller = controller;
        this.parent = pApplet;
        this.name = controller.getName();
        this.setupDevice();
    }

    private void setupDevice() {
        Component[] componentArray = this.controller.getComponents();
        ControlInput controlInput = null;
        for (int i = 0; i < componentArray.length; ++i) {
            controlInput = null;
            if (componentArray[i].isAnalog()) {
                controlInput = componentArray[i].isRelative() ? new ControlRelativeSlider(componentArray[i]) : new ControlSlider(componentArray[i]);
                this.sliders.add((ControlSlider)controlInput);
            } else {
                controlInput = componentArray[i].getIdentifier() == Component.Identifier.Axis.POV ? new ControlHat(componentArray[i], this.parent) : new ControlButton(componentArray[i], this.parent);
                this.buttons.add((ControlButton)controlInput);
            }
            if (controlInput == null) continue;
            this.inputNameMap.put(controlInput.getName(), controlInput);
        }
        this.inputs.addAll(this.sliders);
        this.inputs.addAll(this.buttons);
        this.rumblers = this.controller.getRumblers();
    }

    public boolean matches(Configuration configuration) {
        HashMap<String, ControlInput> hashMap = new HashMap<String, ControlInput>();
        for (Configuration.InputConfig inputConfig : configuration.gameInputs) {
            ControlInput controlInput = this.inputNameMap.get(inputConfig.deviceInputName);
            if (controlInput == null || controlInput.inputType != inputConfig.type) {
                return false;
            }
            hashMap.put(inputConfig.key, controlInput);
            controlInput.setMultiplier(inputConfig.multiplier);
            controlInput.setTolerance(inputConfig.tolerance);
        }
        this.inputNameMap.putAll(hashMap);
        this.available = false;
        this.open();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.controller.getType().toString();
    }

    public String getPortTypeName() {
        return this.controller.getPortType().toString();
    }

    public String toString() {
        return this.controller.getName();
    }

    public void update() {
        if (this.open) {
            this.controller.poll();
            for (int i = 0; i < this.inputs.size(); ++i) {
                this.inputs.get(i).update();
            }
        }
    }

    protected void updateRelative() {
        if (this.open) {
            for (int i = 0; i < this.sliders.size(); ++i) {
                this.sliders.get(i).updateRelative();
            }
        }
    }

    public String toListText(String string) {
        return string + this.name + "     [" + this.getTypeName() + "]  on  [" + this.getPortTypeName() + "]";
    }

    public String toText(String string) {
        StringBuilder stringBuilder = new StringBuilder(string + "========================================================================\n");
        stringBuilder.append(string + "NAME :     " + this.name + "\n");
        stringBuilder.append(string + "Type :     " + this.getTypeName() + "\n");
        stringBuilder.append(string + "Port :     " + this.getPortTypeName() + "\n");
        stringBuilder.append(this.buttonsToText(string));
        stringBuilder.append(this.slidersToText(string));
        stringBuilder.append(string + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        return stringBuilder.toString();
    }

    public String buttonsToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.buttons.size() > 0) {
            stringBuilder.append(string + "  Buttons (" + this.buttons.size() + ")\n");
            stringBuilder.append(string + "    Type     Name               Multiplier\n");
            for (int i = 0; i < this.buttons.size(); ++i) {
                stringBuilder.append(this.buttons.get(i).toText(string + "    ") + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public String slidersToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sliders.size() > 0) {
            stringBuilder.append(string + "  Sliders (" + this.sliders.size() + ")\n");
            stringBuilder.append(string + "    Type     Name               Multiplier     Tolerance\n");
            for (int i = 0; i < this.sliders.size(); ++i) {
                stringBuilder.append(this.sliders.get(i).toText(string + "    ") + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public List<ControlInput> getInputs() {
        return this.inputs;
    }

    public int getNumberOfSliders() {
        return this.sliders.size();
    }

    public ControlSlider getSlider(int n) {
        return this.sliders.get(n);
    }

    public ControlSlider getSlider(String string) {
        try {
            return (ControlSlider)this.inputNameMap.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no slider with the name " + string + ".");
        }
    }

    public void setTolerance(float f) {
        for (int i = 0; i < this.sliders.size(); ++i) {
            this.sliders.get(i).setTolerance(f);
        }
    }

    public int getNumberOfButtons() {
        return this.buttons.size();
    }

    public ControlButton getButton(int n) {
        return this.buttons.get(n);
    }

    public ControlButton getButton(String string) {
        try {
            return (ControlButton)this.inputNameMap.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no button with the name " + string + ".");
        }
    }

    public ControlHat getHat(int n) {
        return (ControlHat)this.buttons.get(n);
    }

    public ControlHat getHat(String string) {
        try {
            return (ControlHat)this.inputNameMap.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no hat with the name " + string + ".");
        }
    }

    public void open() {
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public int getNumberOfRumblers() {
        return this.rumblers.length;
    }

    public void rumble(float f, int n) {
        if (n >= this.rumblers.length) {
            return;
        }
        this.rumblers[n].rumble(f);
    }

    public void rumble(float f) {
        this.rumble(f, 0);
    }

    public void plug(Object object, String string, int n, int n2) {
        this.open();
        this.getButton(n2).plug(object, string, n);
    }

    public void plug(String string, int n, int n2) {
        this.open();
        this.getButton(n2).plug(this.parent, string, n);
    }

    public void plug(Object object, String string, int n, String string2) {
        this.open();
        this.getButton(string2).plug(object, string, n);
    }

    public void plug(String string, int n, String string2) {
        this.open();
        this.getButton(string2).plug(this.parent, string, n);
    }

    public boolean equals(Object object) {
        boolean bl = this.compareTo((ControlDevice)object) == 0;
        return bl;
    }

    @Override
    public int compareTo(ControlDevice controlDevice) {
        String string = this.name + Integer.valueOf(this.buttons.size()).toString() + Integer.valueOf(this.sliders.size()).toString() + Integer.valueOf(this.rumblers.length).toString();
        String string2 = controlDevice.name + Integer.valueOf(controlDevice.buttons.size()).toString() + Integer.valueOf(controlDevice.sliders.size()).toString() + Integer.valueOf(controlDevice.rumblers.length).toString();
        int n = string.compareToIgnoreCase(string2);
        return n;
    }
}

