/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.PCPconstants;
import org.gamecontrolplus.gui.LSelectUI;
import processing.core.PApplet;

public class ControlIO
implements Runnable,
PCPconstants {
    private static ControlIO instance;
    public static ControlDevice configuredDevice;
    public static boolean configurating;
    public final ControllerEnvironment environment;
    private final PApplet parent;
    private final List<ControlDevice> devices = new ArrayList<ControlDevice>();
    private final Thread thread;
    private boolean active = true;

    public static ControlIO getInstance(PApplet pApplet) {
        if (instance == null) {
            instance = new ControlIO(pApplet);
        }
        return instance;
    }

    private ControlIO(PApplet pApplet) {
        this.environment = ControllerEnvironment.getEnvironment();
        this.parent = pApplet;
        Controller[] controllerArray = this.environment.getControllers();
        for (int i = 0; i < controllerArray.length; ++i) {
            this.devices.add(new ControlDevice(controllerArray[i], this.parent));
        }
        this.parent.registerMethod("dispose", (Object)this);
        this.parent.registerMethod("pre", (Object)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void dispose() {
        this.active = false;
    }

    public String deviceListToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "##########################################################################################\n");
        stringBuilder.append(string + "                   Game Control Plus  - available devices\n");
        stringBuilder.append(string + "                   --------------------------------------\n");
        for (int i = 0; i < this.devices.size(); ++i) {
            String string2 = String.valueOf(i + "    ").substring(0, 3);
            stringBuilder.append(string + this.devices.get(i).toListText("  " + string2) + "\n");
        }
        stringBuilder.append(string + "##########################################################################################\n");
        return stringBuilder.toString();
    }

    public String devicesToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "##########################################################################################\n");
        stringBuilder.append(string + "                   Game Control Plus  - available devices\n");
        stringBuilder.append(string + "                   --------------------------------------\n");
        for (int i = 0; i < this.devices.size(); ++i) {
            stringBuilder.append(this.devices.get(i).toText(string + "  "));
        }
        stringBuilder.append(string + "##########################################################################################\n");
        return stringBuilder.toString();
    }

    public int getNumberOfDevices() {
        return this.devices.size();
    }

    public List<ControlDevice> getDevices() {
        return this.devices;
    }

    public ControlDevice getDevice(int n) {
        if (n >= this.getNumberOfDevices()) {
            throw new RuntimeException("There is no device with the number " + n + ".");
        }
        ControlDevice controlDevice = this.devices.get(n);
        controlDevice.open();
        return controlDevice;
    }

    public ControlDevice getDevice(String string) {
        for (int i = 0; i < this.getNumberOfDevices(); ++i) {
            ControlDevice controlDevice = this.devices.get(i);
            if (!controlDevice.getName().equals(string)) continue;
            controlDevice.open();
            return controlDevice;
        }
        throw new RuntimeException("There is no device with the name " + string + ".");
    }

    public ControlDevice getMatchedDevice(String string) {
        Configuration configuration = Configuration.makeConfiguration(this.parent, string);
        return this.getMatchedDevice(configuration);
    }

    public ControlDevice getMatchedDeviceSilent(String string) {
        Configuration configuration = Configuration.makeConfiguration(this.parent, string);
        return this.getMatchedDeviceSilent(configuration);
    }

    public ControlDevice getMatchedDevice(Configuration configuration) {
        for (ControlDevice controlDevice : this.devices) {
            if (!controlDevice.available || !controlDevice.matches(configuration)) continue;
            configuredDevice = controlDevice;
            ControlIO.configuredDevice.available = false;
            configurating = false;
            return controlDevice;
        }
        configurating = true;
        configuredDevice = null;
        new LSelectUI(this.parent, configuration);
        while (configurating) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        ControlDevice controlDevice = configuredDevice;
        configuredDevice = null;
        return controlDevice;
    }

    public ControlDevice getMatchedDeviceSilent(Configuration configuration) {
        for (ControlDevice controlDevice : this.devices) {
            if (!controlDevice.available || !controlDevice.matches(configuration)) continue;
            configuredDevice = controlDevice;
            ControlIO.configuredDevice.available = false;
            configurating = false;
            return controlDevice;
        }
        configurating = false;
        configuredDevice = null;
        return null;
    }

    public void finishedConfig(ControlDevice controlDevice) {
        configuredDevice = controlDevice;
        configurating = false;
    }

    public void pre() {
        for (int i = 0; i < this.devices.size(); ++i) {
            this.devices.get(i).updateRelative();
        }
    }

    @Override
    public void run() {
        while (this.active) {
            for (int i = 0; i < this.devices.size(); ++i) {
                this.devices.get(i).update();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void plug(Object object, String string, int n, int n2, int n3) {
        ControlDevice controlDevice = this.getDevice(n2);
        controlDevice.plug(object, string, n, n3);
    }

    public void plug(String string, int n, int n2, int n3) {
        this.plug((Object)this.parent, string, n, n2, n3);
    }

    public void plug(Object object, String string, int n, String string2, String string3) {
        ControlDevice controlDevice = this.getDevice(string2);
        controlDevice.plug(object, string, n, string3);
    }

    public void plug(String string, int n, String string2, String string3) {
        this.plug((Object)this.parent, string, n, string2, string3);
    }

    static {
        configuredDevice = null;
        configurating = false;
    }
}

