/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.gui.LBase;
import org.gamecontrolplus.gui.LButton;
import org.gamecontrolplus.gui.LConfigUI;
import org.gamecontrolplus.gui.LConnector;
import org.gamecontrolplus.gui.LCoolieHat;
import org.gamecontrolplus.gui.LSlider;

public abstract class LBaseInput
extends LBase {
    int namePos;
    String inputTypeName = "";

    public static LBaseInput makeInputUI(LConfigUI lConfigUI, ControlInput controlInput, float f, float f2) {
        LBaseInput lBaseInput = null;
        if (controlInput instanceof ControlHat) {
            lBaseInput = new LCoolieHat(lConfigUI, (ControlHat)controlInput, f, f2);
        } else if (controlInput instanceof ControlButton) {
            lBaseInput = new LButton(lConfigUI, (ControlButton)controlInput, f, f2);
        } else if (controlInput instanceof ControlSlider) {
            lBaseInput = new LSlider(lConfigUI, (ControlSlider)controlInput, f, f2);
        }
        return lBaseInput;
    }

    public float getValue() {
        return 0.0f;
    }

    public float getMultiplier() {
        return 0.0f;
    }

    public void setTolerance(float f) {
    }

    public void setMultiplier(float f) {
    }

    public float getTolerance() {
        return 0.0f;
    }

    public LBaseInput(LConfigUI lConfigUI, float f, float f2, int n, int n2) {
        super(lConfigUI, f, f2, n);
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i] = new LConnector(this.app, this, i, this.px - lConfigUI.connector_size_r, this.py + ((float)i + 0.0f) * lConfigUI.input_UI_height + lConfigUI.connector_size_r, lConfigUI.connector_size_d);
        }
        this.UI_HEIGHT = (float)n2 * lConfigUI.input_UI_height;
        this.fontBaseLine = (lConfigUI.input_UI_height + lConfigUI.fontSize) / 2.0f;
    }

    protected void drawBackground() {
        this.app.noStroke();
        this.app.fill(this.backCol);
        this.app.rect(0.0f, 0.0f, this.ccw.input_UI_length, this.UI_HEIGHT);
        this.app.fill(-16777088);
        this.app.text(this.name, (float)this.namePos, this.fontBaseLine);
    }

    @Override
    protected void drawConnectors() {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].draw((float)i * this.ccw.input_UI_height);
        }
    }

    protected void drawControlHighlight() {
        this.app.stroke(this.isOver ? -48897 : -12566368);
        this.app.strokeWeight(this.isOver ? 4.0f : 1.0f);
        this.app.noFill();
        this.app.rect(0.0f, 0.0f, this.ccw.input_UI_length, this.UI_HEIGHT);
    }
}

