/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.ControlIO;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.gui.LBase;
import org.gamecontrolplus.gui.LBaseInput;
import org.gamecontrolplus.gui.LConnector;
import org.gamecontrolplus.gui.LConstants;
import org.gamecontrolplus.gui.LDescriptor;
import org.gamecontrolplus.gui.LSelectEntry;
import org.gamecontrolplus.gui.LSelectUI;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAlign;
import org.gamecontrolplus.gui.MButton;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MLabel;
import org.gamecontrolplus.gui.MTabManager;
import org.gamecontrolplus.gui.MTextArea;
import org.gamecontrolplus.gui.MTextField;
import org.gamecontrolplus.gui.MWinData;
import org.gamecontrolplus.gui.MWindow;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.event.MouseEvent;

public class LConfigUI
implements PConstants,
LConstants {
    private final ControlDevice device;
    final ControlIO controlIO;
    final PApplet app;
    final Configuration config;
    private boolean active = false;
    List<LBase> uiElements = new ArrayList<LBase>();
    List<LConnector> uiConnections = new ArrayList<LConnector>();
    private Map<String, LBaseInput> devInpKeys = new HashMap<String, LBaseInput>();
    private Map<String, LDescriptor> descriptors = new HashMap<String, LDescriptor>();
    private StringBuffer report;
    private int errCount = 0;
    MWindow window;
    MTabManager tabManager = new MTabManager();
    MTextField txfFilename;
    MTextArea txaStatus;
    LConnector start = null;
    LConnector end = null;
    LConnector current = null;
    final float scale;
    final float input_UI_height;
    final float desc_UI_height;
    final float element_UI_gap;
    final float input_UI_length;
    final float desc_UI_length;
    final float textfield_gap;
    final float indicator_d;
    final float connector_size_r;
    final float connector_size_d;
    final float fontSize;
    final Font font;
    private boolean dragging = false;

    private void addConfigToGUI(float f, float f2, float f3) {
        float f4 = (float)(this.window.width - 10) - 220.0f - 320.0f;
        float f5 = 4.0f + (f - f3) / 2.0f;
        for (ControlInput controlInput : this.device.getInputs()) {
            LBaseInput lBaseInput = LBaseInput.makeInputUI(this, controlInput, f4, f5);
            if (lBaseInput == null) continue;
            this.uiElements.add(lBaseInput);
            f5 += lBaseInput.UI_HEIGHT + 4.0f;
            this.devInpKeys.put(lBaseInput.name, lBaseInput);
        }
        f4 = 10.0f;
        f5 = 4.0f + (f - f2) / 2.0f;
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            LDescriptor lDescriptor = new LDescriptor(this, f4, f5, inputConfig);
            this.uiElements.add(lDescriptor);
            this.descriptors.put(lDescriptor.name, lDescriptor);
            f5 += lDescriptor.UI_HEIGHT + 4.0f;
        }
        for (LBase lBase : this.uiElements) {
            for (LConnector lConnector : lBase.connectors) {
                this.uiConnections.add(lConnector);
            }
        }
    }

    private void makeExistingConnections() {
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            LBaseInput lBaseInput = this.devInpKeys.get(inputConfig.deviceInputName);
            if (lBaseInput == null || inputConfig.type != lBaseInput.uiType || inputConfig.inputConNo >= lBaseInput.getNbrOfConnectors()) continue;
            LDescriptor lDescriptor = this.descriptors.get(inputConfig.key);
            lDescriptor.connectors[0].conTo = lBaseInput.connectors[inputConfig.inputConNo];
            lBaseInput.connectors[inputConfig.inputConNo].conTo = lDescriptor.connectors[0];
            lBaseInput.setMultiplier(inputConfig.multiplier);
            lBaseInput.setTolerance(inputConfig.tolerance);
        }
    }

    private void addToReport(String string, boolean bl) {
        this.report.append(string);
        if (bl) {
            ++this.errCount;
        }
    }

    private boolean verifyConfig(boolean bl) {
        this.report = new StringBuffer();
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            LDescriptor lDescriptor = this.descriptors.get(inputConfig.key);
            LConnector lConnector = lDescriptor.connectors[0].conTo;
            if (lConnector != null) {
                inputConfig.deviceInputName = lConnector.owner.name;
                inputConfig.inputConNo = lConnector.conNo;
                inputConfig.multiplier = ((LBaseInput)lConnector.owner).getMultiplier();
                inputConfig.tolerance = ((LBaseInput)lConnector.owner).getTolerance();
                continue;
            }
            this.addToReport("No input assigned to: " + lDescriptor.name + "\n", true);
        }
        if (this.errCount > 0) {
            this.addToReport("VERIFY - " + this.errCount + " errors found\n", false);
        } else {
            this.addToReport("VERIFY - successful\n", false);
        }
        if (!bl) {
            this.txaStatus.setText(this.report.toString());
        }
        return this.errCount == 0;
    }

    private boolean saveConfig() {
        if (!this.verifyConfig(true)) {
            this.addToReport("SAVE - abandoned\n", false);
            this.txaStatus.setText(this.report.toString());
            return false;
        }
        Configuration.saveConfiguration(this.app, this.config);
        return true;
    }

    public void verify_click(MButton mButton, MEvent mEvent) {
        this.verifyConfig(false);
    }

    public void use_device_click(MButton mButton, MEvent mEvent) {
        if (this.saveConfig()) {
            System.out.println("Saving config");
            this.device.matches(this.config);
            this.controlIO.finishedConfig(this.device);
            this.window.forceClose();
        }
    }

    public void quit_click(MButton mButton, MEvent mEvent) {
        this.controlIO.finishedConfig(null);
        this.window.forceClose();
    }

    public void clear_click(MButton mButton, MEvent mEvent) {
        this.txaStatus.setText("");
    }

    public synchronized void pre(PApplet pApplet, MWinData mWinData) {
        this.current = null;
        for (LBase lBase : this.uiElements) {
            lBase.update();
            lBase.overWhat(pApplet.mouseX, pApplet.mouseY);
        }
        if (!this.dragging && this.current != null && this.current.conTo != null) {
            this.current.conTo.isOver = true;
        }
    }

    public synchronized void mouse(PApplet pApplet, MWinData mWinData, MouseEvent mouseEvent) {
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.current == null) break;
                this.start = this.current;
                this.dragging = true;
                break;
            }
            case 2: {
                if (this.current != null && this.start != null && this.current.type != this.start.type) {
                    LConnector lConnector = this.current.type == 2 ? this.current : this.start;
                    LDescriptor lDescriptor = (LDescriptor)lConnector.owner;
                    LConnector lConnector2 = this.start.type == 1 ? this.start : this.current;
                    LBaseInput lBaseInput = (LBaseInput)lConnector2.owner;
                    int n = ((LDescriptor)lConnector.owner).iconfig.type;
                    int n2 = lConnector2.owner.uiType;
                    if (n == n2) {
                        this.end = this.current;
                        this.current = null;
                        if (this.start.conTo != null) {
                            this.start.conTo.conTo = null;
                        }
                        if (this.end.conTo != null) {
                            this.end.conTo.conTo = null;
                        }
                        this.start.conTo = this.end;
                        this.end.conTo = this.start;
                        lDescriptor.iconfig.deviceInputName = lBaseInput.name;
                        lBaseInput.setMultiplier(lDescriptor.iconfig.multiplier);
                        lBaseInput.setTolerance(lDescriptor.iconfig.tolerance);
                    }
                }
                this.start = null;
                this.current = null;
                this.dragging = false;
                break;
            }
        }
    }

    public synchronized void draw(PApplet pApplet, MWinData mWinData) {
        pApplet.background(-983056);
        if (!this.active) {
            return;
        }
        pApplet.noStroke();
        pApplet.fill(-14647264);
        pApplet.rect((float)(pApplet.width - 320), 0.0f, 320.0f, (float)pApplet.height);
        pApplet.strokeWeight(3.5f);
        for (LConnector pConstants : this.uiConnections) {
            if (pConstants.conTo == null || pConstants.type != 2) continue;
            pApplet.stroke(pConstants.isOver ? -48897 : -8355680);
            pApplet.line(pConstants.px, pConstants.py, pConstants.conTo.px, pConstants.conTo.py);
        }
        if (this.dragging && this.start != null) {
            pApplet.stroke(-8355680);
            pApplet.line(this.start.px, this.start.py, (float)pApplet.mouseX, (float)pApplet.mouseY);
        }
        for (LBase lBase : this.uiElements) {
            lBase.draw();
        }
    }

    public LConfigUI(PApplet pApplet, LSelectEntry lSelectEntry) {
        this.app = pApplet;
        this.device = lSelectEntry.device;
        lSelectEntry.device.open();
        this.controlIO = lSelectEntry.controlIO;
        this.config = LSelectUI.config;
        float f = 4.0f;
        for (ControlInput controlInput : this.device.getInputs()) {
            if (controlInput instanceof ControlHat) {
                f += 126.0f;
                continue;
            }
            if (controlInput instanceof ControlButton) {
                f += 30.0f;
                continue;
            }
            if (controlInput instanceof ControlSlider) {
                f += 102.0f;
                continue;
            }
            System.out.println("Unknown input " + controlInput);
        }
        float f2 = (float)this.config.nbrInputs() * 36.0f;
        float f3 = Math.max(f, f2);
        this.scale = (float)pApplet.displayHeight < (f3 = Math.max(f3, 280.0f)) + 40.0f ? (float)pApplet.displayHeight / (f3 + 40.0f) : 1.0f;
        int n = Math.round(f3 * this.scale);
        this.input_UI_height = 24.0f * this.scale;
        this.desc_UI_height = 30.0f * this.scale;
        this.element_UI_gap = 4.0f * this.scale;
        this.input_UI_length = 220.0f;
        this.desc_UI_length = 300.0f;
        this.textfield_gap = 4.0f * this.scale;
        this.indicator_d = 12.0f * this.scale;
        this.connector_size_r = 10.0f * this.scale;
        this.connector_size_d = 2.0f * this.connector_size_r;
        this.fontSize = 12.0f * this.scale;
        this.font = new Font("Dialog", 0, (int)this.fontSize);
        String string = "'" + this.device.getName() + "'  [" + this.device.getTypeName() + " on " + this.device.getPortTypeName() + "]";
        this.window = MWindow.getWindow(pApplet, string, 80, 100, 1020, n, "processing.awt.PGraphicsJava2D");
        this.tabManager = new MTabManager();
        M4P.setCursor(1);
        float f4 = this.window.width - 320 + 10;
        float f5 = 300.0f;
        float f6 = 10.0f;
        MLabel mLabel = new MLabel(this.window, f4, f6, f5, 20.0f, "Config. for: " + this.config.getUsgae());
        mLabel.setTextAlign(MAlign.LEFT, null);
        mLabel.setLocalColorScheme(1);
        mLabel.setTextBold();
        mLabel.setOpaque(true);
        float f7 = (f5 - 20.0f) / 3.0f;
        MButton mButton = new MButton(this.window, f4, f6 += 26.0f, f7, 20.0f);
        mButton.setLocalColorScheme(1);
        mButton.setText("Clear Status");
        mButton.addEventHandler(this, "clear_click");
        MButton mButton2 = new MButton(this.window, f4 + (f5 - f7) / 2.0f, f6, f7, 20.0f);
        mButton2.setLocalColorScheme(1);
        mButton2.setText("Verify");
        mButton2.addEventHandler(this, "verify_click");
        MButton mButton3 = new MButton(this.window, f4 + f5 - f7, f6, f7, 20.0f);
        mButton3.setLocalColorScheme(1);
        mButton3.setText("USE");
        mButton3.addEventHandler(this, "use_device_click");
        MLabel mLabel2 = new MLabel(this.window, f4, f6 += 26.0f, f5, 20.0f, "VERIFY / SAVE STATUS REPORT");
        mLabel2.setLocalColorScheme(1);
        mLabel2.setTextBold();
        mLabel2.setOpaque(true);
        this.txaStatus = new MTextArea(this.window, f4, f6 += 22.0f, f5, 140.0f, 1);
        this.txaStatus.setLocalColorScheme(1);
        this.txaStatus.setPromptText("Verify / save status report");
        MButton mButton4 = new MButton(this.window, f4, f6 += this.txaStatus.getHeight() + 4.0f, f5, 20.0f);
        mButton4.setLocalColorScheme(0);
        mButton4.setText("CANCEL CONFIGURATION AND EXIT");
        mButton4.addEventHandler(this, "quit_click");
        this.window.textSize(this.fontSize);
        this.addConfigToGUI(f3, f2, f);
        this.makeExistingConnections();
        this.active = true;
        this.window.addDrawHandler(this, "draw");
        this.window.addMouseHandler(this, "mouse");
        this.window.addPreHandler(this, "pre");
        this.window.loop();
    }

    void close() {
        this.window.forceClose();
    }
}

