/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.gui.LBaseInput;
import org.gamecontrolplus.gui.LConfigUI;

public class LCoolieHat
extends LBaseInput {
    ControlHat button;
    protected float value = 0.0f;
    protected float multiplier = 1.0f;
    protected float x;
    protected float y;
    final boolean[] indicators = new boolean[4];
    final String[] itext = new String[]{"left", "right", "up", "down"};

    public LCoolieHat(LConfigUI lConfigUI, ControlHat controlHat, float f, float f2) {
        super(lConfigUI, f, f2, 1, 5);
        this.uiType = 2;
        this.inputTypeName = "HAT";
        this.button = controlHat;
        this.name = this.button.getName();
        this.namePos = 20 + (int)(lConfigUI.input_UI_length - 20.0f - this.app.textWidth(this.name)) / 2;
        this.backCol = UI_E_BACK[this.uiType];
        this.fontBaseLine = (lConfigUI.desc_UI_height + lConfigUI.fontSize) / 2.0f;
    }

    @Override
    public float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(float f) {
        this.button.setMultiplier(f);
    }

    @Override
    public void update() {
        this.value = this.button.getValue();
        this.x = this.button.getX();
        this.y = this.button.getY();
        this.indicators[0] = this.button.left();
        this.indicators[1] = this.button.right();
        this.indicators[2] = this.button.up();
        this.indicators[3] = this.button.down();
        this.multiplier = this.button.getMultiplier();
    }

    @Override
    public void draw() {
        this.app.pushMatrix();
        this.app.translate(this.px, this.py);
        this.drawBackground();
        this.app.noStroke();
        this.app.fill(-7286640);
        this.app.rect(2.0f, this.ccw.input_UI_height, 60.0f, this.ccw.input_UI_height * 4.0f - 1.0f);
        this.app.stroke(-12566368);
        this.app.strokeWeight(1.0f);
        block6: for (int i = 0; i < 4; ++i) {
            float f = (float)(i + 1) * this.ccw.input_UI_height;
            this.app.fill(this.indicators[i] ? -53200 : -8380384);
            this.app.ellipse(this.ccw.input_UI_height / 2.0f, f + this.ccw.input_UI_height / 2.0f, this.ccw.indicator_d, this.ccw.indicator_d);
            this.app.fill(-16777088);
            this.app.text(this.itext[i], 24.0f, f + this.fontBaseLine);
            switch (i) {
                case 0: {
                    this.app.text("Hat Value:   " + this.value, 72.0f, f + this.fontBaseLine);
                    continue block6;
                }
                case 1: {
                    this.app.text("Multiplier:  " + this.multiplier, 72.0f, f + this.fontBaseLine);
                    continue block6;
                }
                case 2: {
                    this.app.text("X:   " + this.x, 72.0f, f + this.fontBaseLine);
                    continue block6;
                }
                case 3: {
                    this.app.text("Y:   " + this.y, 72.0f, f + this.fontBaseLine);
                }
            }
        }
        this.app.stroke(-12566368);
        this.app.strokeWeight(1.0f);
        this.app.fill(this.value != 0.0f ? -53200 : -8380384);
        this.app.ellipse(this.ccw.input_UI_height / 2.0f, this.ccw.input_UI_height / 2.0f, this.ccw.indicator_d, this.ccw.indicator_d);
        this.drawConnectors();
        this.drawControlHighlight();
        this.app.popMatrix();
    }
}

