/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.util.ArrayList;
import java.util.List;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlIO;
import org.gamecontrolplus.gui.LSelectEntry;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MButton;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MLabel;
import org.gamecontrolplus.gui.MWinData;
import org.gamecontrolplus.gui.MWindow;
import processing.core.PApplet;

public class LSelectUI {
    static Configuration config;
    MWindow window;
    PApplet app;
    ControlIO controlIO;
    List<LSelectEntry> deviceEntries = new ArrayList<LSelectEntry>();

    public LSelectUI(PApplet pApplet, Configuration configuration) {
        M4P.messagesEnabled(false);
        this.app = pApplet;
        config = configuration;
        this.controlIO = ControlIO.getInstance(pApplet);
        List<ControlDevice> list = this.controlIO.getDevices();
        String string = "Select device for " + config.getUsgae();
        this.window = MWindow.getWindow(pApplet, string, 80, 40, 500, 20 * (list.size() + 3), "processing.awt.PGraphicsJava2D");
        this.window.addDrawHandler(this, "draw");
        for (ControlDevice controlDevice : list) {
            if (!controlDevice.available || controlDevice.getTypeName().equalsIgnoreCase("keyboard")) continue;
            this.deviceEntries.add(new LSelectEntry(this, this.controlIO, controlDevice));
        }
        this.createSelectionInterface(this.window);
        for (int i = 0; i < this.deviceEntries.size(); ++i) {
            this.deviceEntries.get(i).setIndex(i);
        }
    }

    public void finishedWith() {
        this.window.forceClose();
    }

    public void createSelectionInterface(PApplet pApplet) {
        MLabel mLabel = new MLabel(pApplet, 0.0f, 0.0f, pApplet.width, 20.0f);
        mLabel.setText("Control devices");
        mLabel.setOpaque(true);
        mLabel.setTextBold();
        MButton mButton = new MButton(pApplet, pApplet.width - 105, pApplet.height - 28, 100.0f, 24.0f);
        mButton.setText("Exit Game");
        mButton.addEventHandler(this, "exitClick");
    }

    public void exitClick(MButton mButton, MEvent mEvent) {
        ControlIO.configurating = false;
        ControlIO.configuredDevice = null;
        this.window.forceClose();
    }

    public synchronized void draw(PApplet pApplet, MWinData mWinData) {
        pApplet.background(255.0f, 255.0f, 220.0f);
        pApplet.stroke(230.0f, 230.0f, 200.0f);
        pApplet.fill(240.0f, 240.0f, 210.0f);
        for (int i = 0; i < pApplet.height; i += 40) {
            pApplet.rect(0.0f, (float)i, (float)pApplet.width, 20.0f);
        }
        pApplet.fill(200.0f, 255.0f, 200.0f);
        pApplet.rect(0.0f, (float)(pApplet.height - 30), (float)pApplet.width, 30.0f);
    }
}

