/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.gui.LBaseInput;
import org.gamecontrolplus.gui.LConfigUI;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MTextField;
import processing.core.PApplet;

public class LSlider
extends LBaseInput {
    ControlSlider slider;
    protected float tolerance = 0.0f;
    protected float value = 0.0f;
    protected float multiplier = 1.0f;

    public LSlider(LConfigUI lConfigUI, ControlSlider controlSlider, float f, float f2) {
        super(lConfigUI, f, f2, 1, 4);
        this.uiType = 3;
        this.inputTypeName = "SLIDER";
        this.slider = controlSlider;
        this.name = this.slider.getName();
        this.namePos = 20 + (int)(lConfigUI.input_UI_length - 20.0f - this.app.textWidth(this.name)) / 2;
        this.backCol = UI_E_BACK[this.uiType];
        this.fontBaseLine = (lConfigUI.desc_UI_height + lConfigUI.fontSize) / 2.0f;
    }

    @Override
    public float getTolerance() {
        return this.tolerance;
    }

    @Override
    public void setTolerance(float f) {
        this.slider.setTolerance(f);
    }

    @Override
    public float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(float f) {
        this.slider.setMultiplier(f);
    }

    public void tolerance_set(MTextField mTextField, MEvent mEvent) {
        if (mEvent == MEvent.ENTERED || mEvent == MEvent.LOST_FOCUS) {
            float f = this.tolerance;
            try {
                this.tolerance = Float.parseFloat(mTextField.getText());
                if (this.tolerance < 0.0f || this.tolerance >= 1.0f) {
                    this.tolerance = f;
                }
                this.slider.setTolerance(this.tolerance);
            }
            catch (NumberFormatException numberFormatException) {
                this.tolerance = f;
            }
            mTextField.setText("" + this.tolerance);
        }
    }

    public void multiplier_set(MTextField mTextField, MEvent mEvent) {
        if (mEvent == MEvent.ENTERED || mEvent == MEvent.LOST_FOCUS) {
            float f = this.multiplier;
            try {
                this.multiplier = Float.parseFloat(mTextField.getText());
                this.slider.setMultiplier(this.multiplier);
            }
            catch (NumberFormatException numberFormatException) {
                this.multiplier = f;
            }
            mTextField.setText("" + this.multiplier);
        }
    }

    @Override
    public void update() {
        this.value = this.slider.getValue();
        this.multiplier = this.slider.getMultiplier();
        this.tolerance = this.slider.getTolerance();
    }

    @Override
    public void draw() {
        this.app.pushMatrix();
        this.app.pushStyle();
        this.app.translate(this.px, this.py);
        this.drawBackground();
        this.app.text("Multiplier  " + this.multiplier, 10.0f, this.ccw.input_UI_height + this.ccw.fontSize);
        this.app.text("Tolerance   " + this.tolerance, 10.0f, 2.0f * this.ccw.input_UI_height + this.ccw.fontSize);
        float f = 10.0f;
        float f2 = this.ccw.input_UI_length - 10.0f;
        float f3 = 1.0f + 3.0f * this.ccw.input_UI_height;
        float f4 = f2 - f;
        float f5 = this.ccw.input_UI_height - 8.0f;
        this.app.noStroke();
        this.app.fill(255.0f, 255.0f, 200.0f);
        this.app.rect(f, f3, f4, f5);
        if (this.tolerance > 0.0f) {
            float f6 = this.tolerance * (f2 - f);
            this.app.fill(255.0f, 200.0f, 200.0f);
            this.app.rect((f2 + f - f6) / 2.0f, f3, f6, f5);
        }
        String string = "" + this.value;
        float f7 = this.app.textWidth(string);
        this.app.fill(0.0f, 0.0f, 0.0f, 120.0f);
        this.app.text(string, (f2 + f - f7) / 2.0f, f3 + this.ccw.fontSize);
        float f8 = PApplet.map((float)this.value, (float)(-this.multiplier), (float)this.multiplier, (float)f, (float)f2);
        this.app.stroke(-49088);
        this.app.strokeWeight(1.0f);
        this.app.line(f8, f3, f8, f3 + f5);
        this.app.fill(-49088);
        this.app.noStroke();
        this.app.beginShape();
        this.app.vertex(f8, f3 + 3.0f);
        this.app.vertex(f8 - 3.0f, f3 - 3.0f);
        this.app.vertex(f8 + 3.0f, f3 - 3.0f);
        this.app.endShape();
        this.app.beginShape();
        this.app.vertex(f8, f3 + f5 - 3.0f);
        this.app.vertex(f8 - 3.0f, f3 + f5 + 3.0f);
        this.app.vertex(f8 + 3.0f, f3 + f5 + 3.0f);
        this.app.endShape();
        this.drawConnectors();
        this.drawControlHighlight();
        this.app.popStyle();
        this.app.popMatrix();
    }
}

