/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MCScheme;
import org.gamecontrolplus.gui.MConstants;
import org.gamecontrolplus.gui.MConstantsInternal;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MHotSpot;
import org.gamecontrolplus.gui.MMessenger;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public abstract class MAbstractControl
implements PConstants,
MConstants,
MConstantsInternal {
    static MAbstractControl focusIsWith = null;
    static MAbstractControl controlToTakeFocus = null;
    static MAbstractControl cursorIsOver;
    static final int Z_PANEL = 1024;
    static final int Z_STICKY = 0;
    static final int Z_SLIPPY = 24;
    protected PApplet winApp;
    protected int z = 0;
    protected boolean dragging = false;
    protected static float epsilon;
    protected MAbstractControl parent = null;
    protected LinkedList<MAbstractControl> children = null;
    protected int localColorScheme = M4P.globalColorScheme;
    protected int[] palette = null;
    protected Color[] jpalette = null;
    protected int alphaLevel = M4P.globalAlpha;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected float halfWidth;
    protected float halfHeight;
    protected float cx;
    protected float cy;
    protected float rotAngle;
    protected double[] temp = new double[2];
    protected PGraphicsJava2D buffer = null;
    protected boolean bufferInvalid = true;
    protected boolean opaque = false;
    protected int cursorOver = 12;
    protected float ox;
    protected float oy;
    public String tag;
    public int tagNo;
    boolean visible = true;
    boolean enabled = true;
    boolean available = true;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    int registeredMethods = 0;
    protected MHotSpot[] hotspots = null;
    protected int currSpot = -1;

    public MAbstractControl(PApplet pApplet) {
        M4P.registerSketch(pApplet);
        this.winApp = pApplet;
        MCScheme.makeColorSchemes(this.winApp);
        this.rotAngle = 0.0f;
        this.z = 0;
        this.palette = MCScheme.getColor(this.localColorScheme);
        this.jpalette = MCScheme.getJavaColor(this.localColorScheme);
    }

    public MAbstractControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet);
        this.setPositionAndSize(f, f2, f3, f4);
        this.buffer = (PGraphicsJava2D)this.winApp.createGraphics((int)this.width, (int)this.height, "processing.awt.PGraphicsJava2D");
        this.buffer.rectMode(0);
        this.buffer.beginDraw();
        this.buffer.endDraw();
        this.tag = this.getClass().getSimpleName();
    }

    private void setPositionAndSize(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        this.halfWidth = this.width / 2.0f;
        this.halfHeight = this.height / 2.0f;
        this.cx = this.x + this.halfWidth;
        this.cy = this.y + this.halfHeight;
    }

    protected void resize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.halfWidth = this.width / 2.0f;
        this.halfHeight = this.height / 2.0f;
        this.cx = this.x + this.halfWidth;
        this.cy = this.y + this.halfHeight;
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent mouseEvent) {
    }

    public void keyEvent(KeyEvent keyEvent) {
    }

    public void pre() {
    }

    public void post() {
    }

    public void dispose() {
        M4P.removeControl(this);
    }

    public void forceBufferUpdate() {
        this.bufferInvalid = true;
    }

    protected int whichHotSpot(float f, float f2) {
        if (this.hotspots == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.hotspots.length; ++i) {
            if (!this.hotspots[i].contains(f, f2)) continue;
            n = this.hotspots[i].id;
            break;
        }
        return n;
    }

    protected int getCurrHotSpot() {
        return this.currSpot;
    }

    public boolean isOver(float f, float f2) {
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        return this.currSpot >= 0;
    }

    public void setLocalColorScheme(int n) {
        if (this.localColorScheme != (n = Math.abs(n) % 16) || this.palette == null) {
            this.localColorScheme = n;
            this.palette = MCScheme.getColor(this.localColorScheme);
            this.jpalette = MCScheme.getJavaColor(this.localColorScheme);
            this.bufferInvalid = true;
        }
    }

    public void setLocalColorScheme(int n, boolean bl) {
        if (this.localColorScheme != (n = Math.abs(n) % 16) || this.palette == null) {
            this.localColorScheme = n;
            this.palette = MCScheme.getColor(this.localColorScheme);
            this.jpalette = MCScheme.getJavaColor(this.localColorScheme);
            this.bufferInvalid = true;
            if (bl && this.children != null) {
                for (MAbstractControl mAbstractControl : this.children) {
                    mAbstractControl.setLocalColorScheme(n, true);
                }
            }
        }
    }

    public int getLocalColorScheme() {
        return this.localColorScheme;
    }

    public void setAlpha(int n) {
        if (this.alphaLevel != (n = Math.abs(n) % 256)) {
            this.alphaLevel = n;
            this.available = this.alphaLevel >= 128;
            this.bufferInvalid = true;
        }
    }

    public void setAlpha(int n, boolean bl) {
        this.setAlpha(n);
        if (bl && this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.setAlpha(n, true);
            }
        }
    }

    public MAbstractControl getParent() {
        return this.parent;
    }

    public PApplet getPApplet() {
        return this.winApp;
    }

    protected PGraphics getBuffer() {
        return this.buffer;
    }

    public PGraphics getSnapshot() {
        if (this.buffer != null) {
            this.updateBuffer();
            PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
            pGraphicsJava2D.beginDraw();
            pGraphicsJava2D.image((PImage)this.buffer, 0.0f, 0.0f);
            return pGraphicsJava2D;
        }
        return null;
    }

    protected void updateBuffer() {
    }

    protected void createEventHandler(Object object, String string, Class[] classArray, String[] stringArray) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            MMessenger.message(0x1000001, new Object[]{this, string, classArray, stringArray});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object object, String string) {
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, this.getClass(), MEvent.class);
        }
        catch (Exception exception) {
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{this.getClass(), MEvent.class}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent(Object ... objectArray) {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, objectArray);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.eventHandlerObject, this.eventHandlerMethodName, exception});
            }
        }
    }

    public void moveTo(float f, float f2) {
        MAbstractControl mAbstractControl = this.parent;
        if (mAbstractControl != null) {
            f -= mAbstractControl.width / 2.0f;
            f2 -= mAbstractControl.height / 2.0f;
        }
        this.cx += f - this.x;
        this.cy += f2 - this.y;
        this.x = this.cx - this.width / 2.0f;
        this.y = this.cy - this.height / 2.0f;
    }

    public float getX() {
        if (this.parent != null) {
            return this.x + this.parent.width / 2.0f;
        }
        return this.x;
    }

    public float getY() {
        if (this.parent != null) {
            return this.y + this.parent.height / 2.0f;
        }
        return this.y;
    }

    public float getCX() {
        if (this.parent != null) {
            return this.x + (this.parent.width + this.width) / 2.0f;
        }
        return this.cx;
    }

    public float getCY() {
        if (this.parent != null) {
            return this.x + (this.parent.width + this.width) / 2.0f;
        }
        return this.cy;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setVisible(boolean bl) {
        if (!bl && focusIsWith == this) {
            this.loseFocus(null);
        }
        this.visible = bl;
        this.available = bl;
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.setAvailable(this.visible);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setAvailable(boolean bl) {
        this.available = bl;
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.setAvailable(bl);
            }
        }
    }

    protected boolean isAvailable() {
        return this.available;
    }

    public void setOpaque(boolean bl) {
        this.bufferInvalid |= bl != this.opaque;
        this.opaque = bl;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.setEnabled(bl);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.loseFocus(this);
        }
        focusIsWith = this;
    }

    protected void loseFocus(MAbstractControl mAbstractControl) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = mAbstractControl;
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.takeFocus();
        } else {
            this.loseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    protected static int focusObjectZ() {
        return focusIsWith == null ? -1 : MAbstractControl.focusIsWith.z;
    }

    public void addControl(MAbstractControl mAbstractControl, float f, float f2, float f3) {
        if (this.children == null) {
            return;
        }
        mAbstractControl.rotAngle = f3;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(f3);
        mAbstractControl.x = f;
        mAbstractControl.y = f2;
        mAbstractControl.temp[0] = mAbstractControl.halfWidth;
        mAbstractControl.temp[1] = mAbstractControl.halfHeight;
        affineTransform.transform(mAbstractControl.temp, 0, mAbstractControl.temp, 0, 1);
        mAbstractControl.cx = (float)mAbstractControl.temp[0] + f - this.halfWidth;
        mAbstractControl.cy = (float)mAbstractControl.temp[1] + f2 - this.halfHeight;
        mAbstractControl.x = mAbstractControl.cx - mAbstractControl.halfWidth;
        mAbstractControl.y = mAbstractControl.cy - mAbstractControl.halfHeight;
        mAbstractControl.rotAngle = f3;
        mAbstractControl.parent = this;
        mAbstractControl.setZ(this.z);
        mAbstractControl.registeredMethods &= 0x1E;
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.addLast(mAbstractControl);
        Collections.sort(this.children, new Z_Order());
        mAbstractControl.addToParent(this);
    }

    public void addControl(MAbstractControl mAbstractControl, float f, float f2) {
        if (this.children == null) {
            return;
        }
        this.addControl(mAbstractControl, f, f2, 0.0f);
    }

    public void addControl(MAbstractControl mAbstractControl) {
        if (this.children == null) {
            return;
        }
        this.addControl(mAbstractControl, mAbstractControl.x, mAbstractControl.y, mAbstractControl.rotAngle);
    }

    public void addControls(MAbstractControl ... mAbstractControlArray) {
        if (this.children == null) {
            return;
        }
        for (MAbstractControl mAbstractControl : mAbstractControlArray) {
            this.addControl(mAbstractControl, mAbstractControl.x, mAbstractControl.y, mAbstractControl.rotAngle);
        }
    }

    protected void addToParent(MAbstractControl mAbstractControl) {
    }

    public int getCursorOver() {
        return this.cursorOver;
    }

    public void setCursorOver(int n) {
        this.cursorOver = n;
    }

    protected AffineTransform getTransform(AffineTransform affineTransform) {
        if (this.parent != null) {
            affineTransform = this.parent.getTransform(affineTransform);
        }
        affineTransform.translate(this.cx, this.cy);
        affineTransform.rotate(this.rotAngle);
        return affineTransform;
    }

    protected void calcTransformedOrigin(float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = this.getTransform(affineTransform);
        this.temp[0] = f;
        this.temp[1] = f2;
        try {
            affineTransform.inverseTransform(this.temp, 0, this.temp, 0, 1);
            this.ox = (float)this.temp[0] + this.halfWidth;
            this.oy = (float)this.temp[1] + this.halfHeight;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    protected void setZ(int n) {
        this.z += n;
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.setZ(n);
            }
        }
    }

    public void markForDisposal() {
        M4P.removeControl(this);
    }

    public String toString() {
        if (this.tag == null) {
            return this.getClass().getSimpleName();
        }
        return this.tag;
    }

    static {
        epsilon = 0.001f;
    }

    public static class Z_Order
    implements Comparator<MAbstractControl> {
        @Override
        public int compare(MAbstractControl mAbstractControl, MAbstractControl mAbstractControl2) {
            if (mAbstractControl.z != mAbstractControl2.z) {
                return new Integer(mAbstractControl.z).compareTo(new Integer(mAbstractControl2.z));
            }
            return new Integer((int)(-mAbstractControl.y)).compareTo(new Integer((int)(-mAbstractControl2.y)));
        }
    }
}

