/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Color;
import javax.swing.ImageIcon;
import org.gamecontrolplus.gui.MConstants;
import processing.core.PApplet;
import processing.core.PImage;

public class MCScheme
implements MConstants {
    private static int[][] palettes = null;
    private static Color[][] jpalettes = null;

    public static int[] getColor(int n) {
        n = Math.abs(n) % 16;
        return palettes[n];
    }

    public static Color[] getJavaColor(int n) {
        n = Math.abs(n) % 16;
        return jpalettes[n];
    }

    public static void makeColorSchemes(PApplet pApplet) {
        if (palettes != null) {
            return;
        }
        PImage pImage = pApplet.loadImage("default_gui_palette.png");
        if (pImage == null) {
            pImage = new PImage(new ImageIcon(new MCScheme().getClass().getResource("/data/default_gui_palette.png")).getImage());
        }
        palettes = new int[16][16];
        jpalettes = new Color[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n;
                MCScheme.palettes[i][j] = n = pImage.get(j * 16 + 8, i * 16 + 8);
                MCScheme.jpalettes[i][j] = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            }
        }
    }
}

