/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class MClip
implements ClipboardOwner {
    private static MClip gclip = null;
    private Clipboard clipboard = null;

    public static boolean copy(String string) {
        if (gclip == null) {
            gclip = new MClip();
        }
        return gclip.copyString(string);
    }

    public static String paste() {
        if (gclip == null) {
            gclip = new MClip();
        }
        return gclip.pasteString();
    }

    private MClip() {
        if (this.clipboard == null) {
            this.makeClipboardObject();
        }
    }

    private void makeClipboardObject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.clipboard = new Clipboard("Application Clipboard");
            }
        } else {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean copyString(String string) {
        if (this.clipboard == null) {
            this.makeClipboardObject();
        }
        if (this.clipboard != null) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, this);
            return true;
        }
        return false;
    }

    private String pasteString() {
        if (this.clipboard == null) {
            this.makeClipboardObject();
            return "";
        }
        Transferable transferable = this.clipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

