/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.gamecontrolplus.gui.MConstantsInternal;
import processing.core.PApplet;

public final class MStyledString
implements MConstantsInternal,
Serializable {
    private static final long serialVersionUID = 8380395122026579368L;
    private transient AttributedString styledText = null;
    private transient ImageGraphicAttribute spacer = null;
    private transient LineBreakMeasurer lineMeasurer = null;
    private transient LinkedList<TextLayoutInfo> linesInfo = new LinkedList();
    private transient Font font = null;
    private String plainText = "";
    private LinkedList<AttributeRun> baseStyle = new LinkedList();
    private LinkedList<AttributeRun> atrun = new LinkedList();
    private int wrapWidth = Integer.MAX_VALUE;
    private boolean invalidLayout = true;
    private boolean invalidText = true;
    private boolean justify = false;
    private float justifyRatio = 0.7f;
    private float textHeight = 0.0f;
    private float maxLineLength = 0.0f;
    private float maxLineHeight = 0.0f;
    private int nbrLines;
    int startIdx = -1;
    int endIdx = -1;

    public MStyledString(String string) {
        this.plainText = this.removeSingleSpacingFromPlainText(string);
        this.spacer = this.getParagraghSpacer(1);
        this.styledText = new AttributedString(this.plainText);
        this.applyAttributes();
        this.invalidText = true;
        this.invalidLayout = true;
    }

    public MStyledString(String string, int n) {
        if (n > 0 && n < Integer.MAX_VALUE) {
            this.wrapWidth = n;
        }
        this.plainText = n == Integer.MAX_VALUE ? this.removeSingleSpacingFromPlainText(string) : this.removeDoubleSpacingFromPlainText(string);
        this.spacer = this.getParagraghSpacer(this.wrapWidth);
        this.styledText = new AttributedString(this.plainText);
        this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
        this.applyAttributes();
        this.invalidText = true;
        this.invalidLayout = true;
    }

    MStyledString convertToSingleLineText() {
        if (this.styledText == null || this.plainText == null) {
            this.plainText = "";
            this.styledText = new AttributedString(this.plainText);
        } else {
            int n = this.plainText.indexOf(10, 0);
            if (n >= 0) {
                while (n >= 0) {
                    try {
                        this.styledText.addAttribute(TextAttribute.CHAR_REPLACEMENT, Character.valueOf(' '), n, n + 1);
                        n = this.plainText.indexOf(10, n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
                this.plainText = this.plainText.replace('\n', ' ');
            }
        }
        this.wrapWidth = Integer.MAX_VALUE;
        return this;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public String[] getPlainTextAsArray() {
        return this.plainText.split("\n");
    }

    public int length() {
        return this.plainText.length();
    }

    public void setJustify(boolean bl) {
        if (this.justify != bl) {
            this.justify = bl;
            this.invalidLayout = true;
        }
    }

    public void setJustifyRatio(float f) {
        if (this.justifyRatio != f) {
            this.justifyRatio = f;
            if (this.justify) {
                this.invalidLayout = true;
            }
        }
    }

    private AttributedString insertParagraphMarkers(String string, AttributedString attributedString) {
        if (string != null && string.length() > 0) {
            this.plainText = string;
        }
        int n = string.indexOf(10, 0);
        while (n >= 0) {
            try {
                attributedString.addAttribute(TextAttribute.CHAR_REPLACEMENT, this.spacer, n, n + 1);
                n = string.indexOf(10, n + 1);
            }
            catch (Exception exception) {
                break;
            }
        }
        return attributedString;
    }

    private Object validateTextAttributeColor(TextAttribute textAttribute, Object object) {
        if (!(textAttribute != TextAttribute.BACKGROUND && textAttribute != TextAttribute.FOREGROUND || object instanceof Color)) {
            return new Color((Integer)object);
        }
        return object;
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        this.addAttribute(attribute, object, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2, int n3) {
        if (n < this.linesInfo.size()) {
            TextLayoutInfo textLayoutInfo = this.linesInfo.get(n);
            int n4 = textLayoutInfo.startCharIndex;
            n3 = Math.min(n3, textLayoutInfo.nbrChars);
            this.addAttribute(attribute, object, n4 + n2, n4 + n3);
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        object = this.validateTextAttributeColor((TextAttribute)attribute, object);
        AttributeRun attributeRun = new AttributeRun(attribute, object, n, n2);
        if (this.atrun.size() > 0) {
            ListIterator<AttributeRun> listIterator = this.atrun.listIterator(this.atrun.size());
            while (listIterator.hasPrevious()) {
                AttributeRun attributeRun2 = listIterator.previous();
                int n3 = attributeRun.intersectionWith(attributeRun2);
                int n4 = n3 & 0x3F;
                int n5 = n3 & 0x300;
                if (n5 == 256) {
                    switch (n4) {
                        case 1: 
                        case 4: {
                            attributeRun.start = attributeRun2.start;
                            listIterator.remove();
                            break;
                        }
                        case 2: 
                        case 8: {
                            attributeRun.end = attributeRun2.end;
                            listIterator.remove();
                        }
                    }
                } else if (n5 == 512) {
                    switch (n4) {
                        case 4: {
                            attributeRun2.end = attributeRun.start;
                            break;
                        }
                        case 8: {
                            attributeRun2.start = attributeRun.end;
                        }
                    }
                }
                switch (n4) {
                    case 16: {
                        listIterator.remove();
                        break;
                    }
                    case 32: {
                        attributeRun = null;
                    }
                }
            }
        }
        if (attributeRun != null) {
            this.atrun.addLast(attributeRun);
        }
        this.applyAttributes();
        this.invalidLayout = true;
    }

    public void clearAttributes(int n, int n2, int n3) {
        if (n < this.linesInfo.size()) {
            TextLayoutInfo textLayoutInfo = this.linesInfo.get(n);
            int n4 = textLayoutInfo.startCharIndex;
            n3 = Math.min(n3, textLayoutInfo.nbrChars);
            this.clearAttributes(n4 + n2, n4 + n3);
        }
    }

    public void clearAttributes(int n, int n2) {
        ListIterator<AttributeRun> listIterator = this.atrun.listIterator();
        while (listIterator.hasNext()) {
            AttributeRun attributeRun = (AttributeRun)listIterator.next();
            if (n >= attributeRun.end && n2 >= attributeRun.start) continue;
            int n3 = Math.max(n, attributeRun.start);
            int n4 = Math.min(n2, attributeRun.end);
            if (attributeRun.start == n3 && attributeRun.end == n4) {
                listIterator.remove();
                continue;
            }
            if (attributeRun.start == n3) {
                attributeRun.start = n4;
                continue;
            }
            if (attributeRun.end == n4) {
                attributeRun.end = n3;
                continue;
            }
            AttributeRun attributeRun2 = new AttributeRun(attributeRun.atype, attributeRun.value, n4, attributeRun.end);
            listIterator.add(attributeRun2);
            attributeRun.end = n3;
        }
        this.invalidText = true;
    }

    public void clearAttributes() {
        this.atrun.clear();
        this.invalidText = true;
    }

    private void applyAttributes() {
        if (this.plainText.length() > 0) {
            for (AttributeRun attributeRun : this.baseStyle) {
                this.styledText.addAttribute(attributeRun.atype, attributeRun.value);
            }
            Iterator iterator = this.atrun.iterator();
            while (iterator.hasNext()) {
                AttributeRun attributeRun;
                attributeRun = (AttributeRun)iterator.next();
                if (attributeRun.end == Integer.MAX_VALUE) {
                    this.styledText.addAttribute(attributeRun.atype, attributeRun.value);
                    continue;
                }
                try {
                    this.styledText.addAttribute(attributeRun.atype, attributeRun.value, attributeRun.start, attributeRun.end);
                }
                catch (Exception exception) {
                    System.out.println("Dumping " + attributeRun);
                    exception.printStackTrace();
                    iterator.remove();
                }
            }
        }
        this.invalidLayout = true;
    }

    public int insertCharacters(int n, String string) {
        if (string.length() > 0) {
            string = this.makeStringSafeForInsert(string);
        }
        return this.insertCharactersImpl(n, string, false);
    }

    public int insertCharacters(int n, String string, boolean bl) {
        if (string.length() > 0) {
            string = this.makeStringSafeForInsert(string);
        }
        return this.insertCharactersImpl(n, string, bl);
    }

    private int insertCharactersImpl(int n, String string, boolean bl) {
        if (string.length() > 0) {
            if (bl) {
                string = "\n" + string;
            }
            int n2 = string.length();
            this.plainText = this.plainText.equals(" ") ? string : this.plainText.substring(0, n) + string + this.plainText.substring(n);
            this.insertParagraphMarkers(this.plainText, this.styledText);
            for (AttributeRun attributeRun : this.atrun) {
                if (attributeRun.end >= Integer.MAX_VALUE || attributeRun.end < n) continue;
                AttributeRun attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.end + n2);
                attributeRun2.end = attributeRun2.end;
                if (attributeRun.start < n) continue;
                attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.start + n2);
                attributeRun2.start = attributeRun2.start;
            }
            this.invalidText = true;
        }
        return string.length();
    }

    private String makeStringSafeForInsert(String string) {
        if (string.length() > 0) {
            if (this.wrapWidth == Integer.MAX_VALUE) {
                string = this.removeSingleSpacingFromPlainText(string);
            } else {
                string = this.removeDoubleSpacingFromPlainText(string);
                while (string.length() > 0 && string.charAt(0) == '\n') {
                    string = string.substring(1);
                }
                while (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
            }
        }
        return string;
    }

    public boolean insertEOL(int n) {
        if (this.wrapWidth != Integer.MAX_VALUE) {
            if (n > 0 && this.plainText.charAt(n - 1) == '\n') {
                return false;
            }
            if (n < this.plainText.length() - 1 && this.plainText.charAt(n + 1) == '\n') {
                return false;
            }
            this.plainText = this.plainText.substring(0, n) + "\n" + this.plainText.substring(n);
            this.insertParagraphMarkers(this.plainText, this.styledText);
            for (AttributeRun attributeRun : this.atrun) {
                if (attributeRun.end >= Integer.MAX_VALUE || attributeRun.end < n) continue;
                AttributeRun attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.end + 1);
                attributeRun2.end = attributeRun2.end;
                if (attributeRun.start < n) continue;
                attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.start + 1);
                attributeRun2.start = attributeRun2.start;
            }
            this.invalidText = true;
            return true;
        }
        return false;
    }

    public boolean deleteCharacters(int n, int n2) {
        if (n < 0 || n + n2 > this.plainText.length()) {
            return false;
        }
        if (this.wrapWidth != Integer.MAX_VALUE && n > 0 && n + n2 < this.plainText.length() - 1 && this.plainText.charAt(n) == '\n' && this.plainText.charAt(n + n2) == '\n') {
            ++n2;
        }
        this.plainText = n != 0 ? this.plainText.substring(0, n) + this.plainText.substring(n + n2) : this.plainText.substring(n + n2);
        if (this.plainText.length() == 0) {
            this.atrun.clear();
            this.styledText = null;
        } else {
            ListIterator<AttributeRun> listIterator = this.atrun.listIterator(this.atrun.size());
            while (listIterator.hasPrevious()) {
                AttributeRun attributeRun;
                AttributeRun attributeRun2 = listIterator.previous();
                if (attributeRun2.end >= Integer.MAX_VALUE || attributeRun2.end < n) continue;
                int n3 = n + n2;
                if (n <= attributeRun2.start && n3 >= attributeRun2.end) {
                    listIterator.remove();
                    continue;
                }
                if (n > attributeRun2.start && n3 < attributeRun2.end) {
                    attributeRun = attributeRun2;
                    Integer.valueOf(attributeRun.end - n2);
                    attributeRun.end = attributeRun.end;
                    continue;
                }
                if (n <= attributeRun2.start) {
                    attributeRun2.start = n;
                    attributeRun = attributeRun2;
                    Integer.valueOf(attributeRun.end - n2);
                    attributeRun.end = attributeRun.end;
                    continue;
                }
                if (n3 >= attributeRun2.end) {
                    attributeRun2.end = n;
                    continue;
                }
                System.out.println("This run was not modified");
                System.out.println("Run from " + attributeRun2.start + " to " + attributeRun2.end);
                System.out.println("Delete from " + n + " To " + n3 + "  (" + n2 + " to remove)");
            }
        }
        this.invalidText = true;
        return true;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.baseStyle.clear();
            this.baseStyle.add(new AttributeRun(TextAttribute.FAMILY, this.font.getFamily()));
            this.baseStyle.add(new AttributeRun(TextAttribute.SIZE, this.font.getSize()));
            if (this.font.isBold()) {
                this.baseStyle.add(new AttributeRun(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
            }
            if (this.font.isItalic()) {
                this.baseStyle.add(new AttributeRun(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE));
            }
            this.invalidText = true;
        }
    }

    public LinkedList<TextLayoutInfo> getLines(Graphics2D graphics2D) {
        if (this.font != graphics2D.getFont()) {
            this.setFont(graphics2D.getFont());
            this.invalidText = true;
        }
        if (this.invalidText) {
            this.styledText = new AttributedString(this.plainText);
            this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
            this.applyAttributes();
            this.invalidText = false;
            this.invalidLayout = true;
        }
        if (this.invalidLayout) {
            this.linesInfo.clear();
            if (this.plainText.length() > 0) {
                this.textHeight = 0.0f;
                this.maxLineLength = 0.0f;
                this.maxLineHeight = 0.0f;
                this.nbrLines = 0;
                AttributedCharacterIterator attributedCharacterIterator = this.styledText.getIterator(null, 0, this.plainText.length());
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                this.lineMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = 0.0f;
                int n = 0;
                while (this.lineMeasurer.getPosition() < this.plainText.length()) {
                    float f2;
                    TextLayout textLayout = this.lineMeasurer.nextLayout(this.wrapWidth);
                    float f3 = textLayout.getVisibleAdvance();
                    if (this.justify && this.justify && f3 > this.justifyRatio * (float)this.wrapWidth) {
                        f2 = f3 > (float)this.wrapWidth ? f3 - (float)this.wrapWidth : (float)this.wrapWidth;
                        textLayout = textLayout.getJustifiedLayout(f2);
                    }
                    if ((f2 = this.getHeight(textLayout)) > this.maxLineHeight) {
                        this.maxLineHeight = f2;
                    }
                    this.textHeight += f2;
                    if (f3 <= (float)this.wrapWidth && f3 > this.maxLineLength) {
                        this.maxLineLength = f3;
                    }
                    this.linesInfo.add(new TextLayoutInfo(this.nbrLines, textLayout, n, textLayout.getCharacterCount(), f));
                    n += textLayout.getCharacterCount();
                    f += f2;
                    ++this.nbrLines;
                }
            }
            this.invalidLayout = false;
        }
        return this.linesInfo;
    }

    public int getNbrLines() {
        return this.nbrLines;
    }

    public float getTextAreaHeight() {
        return this.textHeight;
    }

    public float getMaxLineLength() {
        return this.maxLineLength;
    }

    public float getMaxLineHeight() {
        return this.maxLineHeight;
    }

    private float getHeight(TextLayout textLayout) {
        return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int n) {
        if (this.wrapWidth != n) {
            this.wrapWidth = n;
            this.invalidLayout = true;
        }
    }

    TextLayoutHitInfo calculateFromXY(Graphics2D graphics2D, float f, float f2) {
        TextHitInfo textHitInfo = null;
        TextLayoutInfo textLayoutInfo = null;
        TextLayoutHitInfo textLayoutHitInfo = null;
        if (this.invalidLayout) {
            this.getLines(graphics2D);
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        textLayoutInfo = this.getTLIforYpos(f2);
        textHitInfo = textLayoutInfo.layout.hitTestChar(f, f2 -= textLayoutInfo.yPosInPara);
        textLayoutHitInfo = new TextLayoutHitInfo(textLayoutInfo, textHitInfo);
        return textLayoutHitInfo;
    }

    TextLayoutInfo getTLIforLineNo(int n) {
        if (n >= 0 || n < this.linesInfo.size()) {
            return this.linesInfo.get(n);
        }
        return null;
    }

    TextLayoutInfo getTLIforYpos(float f) {
        TextLayoutInfo textLayoutInfo = null;
        if (!this.linesInfo.isEmpty()) {
            for (int i = this.linesInfo.size() - 1; i >= 0; --i) {
                textLayoutInfo = this.linesInfo.get(i);
                if (textLayoutInfo.yPosInPara <= f) break;
            }
        }
        return textLayoutInfo;
    }

    TextLayoutInfo getTLIforCharNo(int n) {
        TextLayoutInfo textLayoutInfo = null;
        if (!this.linesInfo.isEmpty()) {
            for (int i = this.linesInfo.size() - 1; i >= 0; --i) {
                textLayoutInfo = this.linesInfo.get(i);
                if (textLayoutInfo.startCharIndex < n) break;
            }
        }
        return textLayoutInfo;
    }

    TextLayoutHitInfo getTLHIforCharPosition(int n, int n2) {
        TextLayoutHitInfo textLayoutHitInfo = null;
        TextHitInfo textHitInfo = null;
        TextLayoutInfo textLayoutInfo = this.getTLIforLineNo(n);
        if (textLayoutInfo != null && (textHitInfo = textLayoutInfo.layout.getNextRightHit(n2 = PApplet.constrain((int)n2, (int)0, (int)(textLayoutInfo.nbrChars - 2)))) != null) {
            textLayoutHitInfo = new TextLayoutHitInfo(textLayoutInfo, textHitInfo);
        }
        return textLayoutHitInfo;
    }

    private String removeDoubleSpacingFromPlainText(String string) {
        while (string.indexOf("\n\n") >= 0) {
            this.invalidText = true;
            string = string.replaceAll("\n\n", "\n");
        }
        return string;
    }

    private String removeSingleSpacingFromPlainText(String string) {
        while (string.indexOf("\n") >= 0) {
            this.invalidText = true;
            string = string.replaceAll("\n", "");
        }
        return string;
    }

    private ImageGraphicAttribute getParagraghSpacer(int n) {
        if (n == Integer.MAX_VALUE) {
            n = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n, 10, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return new ImageGraphicAttribute(bufferedImage, -1);
    }

    public static void save(PApplet pApplet, MStyledString mStyledString, String string) {
        try {
            OutputStream outputStream = pApplet.createOutput(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(mStyledString);
            outputStream.close();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static MStyledString load(PApplet pApplet, String string) {
        MStyledString mStyledString = null;
        try {
            InputStream inputStream = pApplet.createInput(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            mStyledString = (MStyledString)objectInputStream.readObject();
            inputStream.close();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return mStyledString;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.spacer = this.getParagraghSpacer(this.wrapWidth);
        this.styledText = new AttributedString(this.plainText);
        this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
        this.linesInfo = new LinkedList();
        this.applyAttributes();
    }

    private class AttributeRun
    implements Serializable {
        private static final long serialVersionUID = -8401062069478890163L;
        public AttributedCharacterIterator.Attribute atype;
        public Object value;
        public Integer start;
        public Integer end;

        public AttributeRun(AttributedCharacterIterator.Attribute attribute, Object object) {
            this.atype = attribute;
            this.value = object;
            this.start = Integer.MIN_VALUE;
            this.end = Integer.MAX_VALUE;
        }

        public AttributeRun(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            this.atype = attribute;
            this.value = object;
            this.start = n;
            this.end = n2;
        }

        private int intersectionWith(AttributeRun attributeRun) {
            if (this.atype != attributeRun.atype) {
                return 0;
            }
            int n = this.value.equals(attributeRun.value) ? 256 : 512;
            int n2 = 4;
            int n3 = 0;
            if (attributeRun.start < this.start) {
                n2 = 0;
            } else if (attributeRun.start == this.start) {
                n2 = 1;
            } else if (attributeRun.start < this.end) {
                n2 = 2;
            } else if (attributeRun.start == this.end) {
                n2 = 3;
            }
            if (n2 < 4) {
                if (attributeRun.end > this.end) {
                    n3 = 4;
                } else if (attributeRun.end == this.end) {
                    n3 = 3;
                } else if (attributeRun.end > this.start) {
                    n3 = 2;
                } else if (attributeRun.end == this.start) {
                    n3 = 1;
                }
            }
            return n |= MConstantsInternal.grid[n2][n3];
        }

        public String toString() {
            String string = this.atype.toString() + "  value = " + this.value.toString() + "  from " + this.start + "   to " + this.end;
            return string;
        }
    }

    public static class TextLayoutInfo
    implements Comparable<TextLayoutInfo> {
        public TextLayout layout;
        public int lineNo;
        public int startCharIndex;
        public int nbrChars;
        public float yPosInPara;

        public TextLayoutInfo(int n, TextLayout textLayout, int n2, int n3, float f) {
            this.lineNo = n;
            this.layout = textLayout;
            this.startCharIndex = n2;
            this.nbrChars = n3;
            this.yPosInPara = f;
        }

        @Override
        public int compareTo(TextLayoutInfo textLayoutInfo) {
            if (this.lineNo == textLayoutInfo.lineNo) {
                return 0;
            }
            return this.startCharIndex < textLayoutInfo.startCharIndex ? -1 : 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{ Line no = " + this.lineNo + "    starts @ char pos " + this.startCharIndex);
            stringBuilder.append("  last index " + (this.startCharIndex + this.nbrChars + 1));
            stringBuilder.append("  (" + this.nbrChars + ")  ");
            return new String(stringBuilder);
        }
    }

    public static class TextLayoutHitInfo
    implements Comparable<TextLayoutHitInfo> {
        public TextLayoutInfo tli;
        public TextHitInfo thi;

        public TextLayoutHitInfo() {
            this.tli = null;
            this.thi = null;
        }

        public TextLayoutHitInfo(TextLayoutInfo textLayoutInfo) {
            this.tli = textLayoutInfo;
            this.thi = null;
        }

        public TextLayoutHitInfo(TextLayoutInfo textLayoutInfo, TextHitInfo textHitInfo) {
            this.tli = textLayoutInfo;
            this.thi = textHitInfo;
        }

        public TextLayoutHitInfo(TextLayoutHitInfo textLayoutHitInfo) {
            this.tli = textLayoutHitInfo.tli;
            this.thi = textLayoutHitInfo.thi;
        }

        public void copyFrom(TextLayoutHitInfo textLayoutHitInfo) {
            this.tli = textLayoutHitInfo.tli;
            this.thi = textLayoutHitInfo.thi;
        }

        public void setInfo(TextLayoutInfo textLayoutInfo, TextHitInfo textHitInfo) {
            this.tli = textLayoutInfo;
            this.thi = textHitInfo;
        }

        @Override
        public int compareTo(TextLayoutHitInfo textLayoutHitInfo) {
            int n = this.tli.compareTo(textLayoutHitInfo.tli);
            if (n != 0) {
                return n;
            }
            if (this.thi.equals(textLayoutHitInfo.thi)) {
                return 0;
            }
            if (this.thi.getCharIndex() != textLayoutHitInfo.thi.getCharIndex()) {
                return this.thi.getCharIndex() < textLayoutHitInfo.thi.getCharIndex() ? -1 : 1;
            }
            return this.thi.isLeadingEdge() ? -1 : 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.tli.toString());
            stringBuilder.append("  Hit char = " + this.thi.getCharIndex());
            return new String(stringBuilder);
        }
    }
}

