/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MClip;
import org.gamecontrolplus.gui.MEditableTextControl;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MHotSpot;
import org.gamecontrolplus.gui.MScrollbar;
import org.gamecontrolplus.gui.MStyledString;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class MTextArea
extends MEditableTextControl {
    private static float pad = 6.0f;
    protected boolean newline = false;
    protected boolean backspace = false;

    public MTextArea(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0, Integer.MAX_VALUE);
    }

    public MTextArea(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        this(pApplet, f, f2, f3, f4, n, Integer.MAX_VALUE);
    }

    public MTextArea(PApplet pApplet, float f, float f2, float f3, float f4, int n, int n2) {
        super(pApplet, f, f2, f3, f4, n);
        this.children = new LinkedList();
        this.tx = this.ty = pad;
        this.tw = this.width - 2.0f * pad - (float)((this.scrollbarPolicy & 1) != 0 ? 18 : 0);
        this.th = this.height - 2.0f * pad - (float)((this.scrollbarPolicy & 2) != 0 ? 18 : 0);
        this.wrapWidth = n2 == Integer.MAX_VALUE ? (int)this.tw : n2;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new MHotSpot[]{new MHotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new MHotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        M4P.pushStyle();
        M4P.showMessages = false;
        this.z = 0;
        if ((this.scrollbarPolicy & 2) != 0) {
            this.hsb = new MScrollbar(pApplet, 0.0f, 0.0f, this.tw, 16.0f);
            this.addControl(this.hsb, this.tx, this.ty + this.th + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        if ((this.scrollbarPolicy & 1) != 0) {
            this.vsb = new MScrollbar(pApplet, 0.0f, 0.0f, this.th, 16.0f);
            this.addControl(this.vsb, this.tx + this.tw + 18.0f, this.ty, 1.5707964f);
            this.vsb.addEventHandler(this, "vsbEventHandler");
            this.vsb.setAutoHide(this.autoHide);
        }
        this.setScrollbarValues(0.0f, 0.0f);
        M4P.popStyle();
        this.setText("");
        this.createEventHandler(M4P.sketchWindow, "handleTextEvents", new Class[]{MEditableTextControl.class, MEvent.class}, new String[]{"textcontrol", "event"});
        this.registeredMethods = 15;
        M4P.registerControl(this);
        this.bufferInvalid = true;
    }

    @Override
    public void setPromptText(String string) {
        if (string == null || string.length() == 0) {
            this.promptText = null;
        } else {
            this.promptText = new MStyledString(string, this.wrapWidth);
            this.promptText.addAttribute(M4P.POSTURE, M4P.POSTURE_OBLIQUE);
        }
        this.bufferInvalid = true;
    }

    @Override
    public void setText(String string) {
        if (this.stext == null) {
            this.setText(string, this.wrapWidth);
        } else {
            this.setText(string, this.stext.getWrapWidth());
        }
        this.bufferInvalid = true;
    }

    public void setText(String string, int n) {
        this.setStyledText(new MStyledString(string, n));
        this.bufferInvalid = true;
    }

    public void setText(String[] stringArray) {
        if (stringArray != null) {
            this.setText(PApplet.join((String[])stringArray, (String)"\n"));
            this.bufferInvalid = true;
        }
    }

    public void setText(String[] stringArray, int n) {
        if (stringArray != null) {
            this.setText(PApplet.join((String[])stringArray, (String)"\n"), n);
            this.bufferInvalid = true;
        }
    }

    public String[] getTextAsArray() {
        return this.stext.getPlainTextAsArray();
    }

    public void addStyle(TextAttribute textAttribute, Object object, int n, int n2, int n3) {
        if (this.stext != null) {
            this.stext.addAttribute(textAttribute, object, n, n2, n3);
            this.bufferInvalid = true;
        }
    }

    public void clearStyles(int n, int n2, int n3) {
        if (this.stext != null) {
            this.stext.clearAttributes(n, n2, n3);
            this.bufferInvalid = true;
        }
    }

    @Override
    public void setStyledText(MStyledString mStyledString) {
        this.stext = mStyledString;
        if (this.stext.getWrapWidth() == Integer.MAX_VALUE) {
            this.stext.setWrapWidth(this.wrapWidth);
        } else {
            this.wrapWidth = this.stext.getWrapWidth();
        }
        this.stext.getLines(this.buffer.g2);
        if (this.stext.getNbrLines() > 0) {
            this.endTLHI.tli = this.stext.getLines(this.buffer.g2).getFirst();
            this.endTLHI.thi = this.endTLHI.tli.layout.getNextLeftHit(1);
            this.startTLHI.copyFrom(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
            this.keepCursorInView = true;
        }
        this.pty = 0.0f;
        this.ptx = 0.0f;
        if (this.vsb != null) {
            float f = this.stext.getTextAreaHeight();
            if (f < this.th) {
                this.vsb.setValue(0.0f, 1.0f);
            } else {
                this.vsb.setValue(0.0f, this.th / f);
            }
        }
        if (this.hsb != null) {
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(0.0f, this.tw / this.stext.getMaxLineLength());
            }
        }
        this.bufferInvalid = true;
    }

    public void appendText(String string) {
        float f;
        if (string == null || string.equals("")) {
            return;
        }
        if (this.stext.insertCharacters(this.stext.length(), string, true) == 0) {
            return;
        }
        LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
        this.endTLHI.tli = linkedList.getLast();
        this.endTLHI.thi = this.endTLHI.tli.layout.getNextRightHit(this.endTLHI.tli.nbrChars - 1);
        this.startTLHI.copyFrom(this.endTLHI);
        this.calculateCaretPos(this.endTLHI);
        if (this.vsb != null) {
            f = Math.min(1.0f, this.th / this.stext.getTextAreaHeight());
            this.vsb.setValue(1.0f - f, f);
            this.keepCursorInView = true;
        }
        if (this.hsb != null) {
            f = linkedList.getLast().layout.getVisibleAdvance();
            float f2 = this.stext.getMaxLineLength();
            float f3 = Math.min(1.0f, this.tw / f2);
            if (this.caretX < this.tw) {
                this.hsb.setValue(0.0f, f3);
            } else {
                this.hsb.setValue(f / f2, f3);
            }
            this.keepCursorInView = true;
        }
        this.bufferInvalid = true;
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            if (linkedList.isEmpty() && this.promptText != null) {
                linkedList = this.promptText.getLines(graphics2D);
            }
            this.bufferInvalid = false;
            MStyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            MStyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            if (this.opaque) {
                this.buffer.background(this.palette[6]);
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7]);
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            if (this.hasSelection()) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            for (MStyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                if (this.hasSelection() && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                    int n = 0;
                    n = textLayoutInfo.compareTo(textLayoutHitInfo.tli) == 0 ? textLayoutHitInfo.thi.getInsertionIndex() : 0;
                    int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                    n2 = textLayoutInfo.compareTo(textLayoutHitInfo2.tli) == 0 ? textLayoutHitInfo2.thi.getInsertionIndex() : textLayoutInfo.nbrChars - 1;
                    graphics2D.setColor(this.jpalette[14]);
                    Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            boolean bl2 = false;
            float f = this.caretX - this.tw + 2.0f;
            float f2 = this.caretY - this.th + 2.0f * this.stext.getMaxLineHeight();
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= HORZ_SCROLL_RATE;
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += HORZ_SCROLL_RATE;
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.pty > this.caretY) {
                    this.pty -= VERT_SCROLL_RATE;
                    if (this.pty < 0.0f) {
                        this.pty = 0.0f;
                    }
                    bl2 = true;
                } else if (this.pty < f2) {
                    this.pty += VERT_SCROLL_RATE;
                    bl2 = true;
                }
                if (bl && this.hsb != null) {
                    this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
                }
                if (bl2 && this.vsb != null) {
                    this.vsb.setValue(this.pty / (this.stext.getTextAreaHeight() + 1.5f * this.stext.getMaxLineHeight()));
                }
            }
            if (bl || bl2) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.9f);
                this.winApp.stroke(this.palette[15]);
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphicsJava2D.beginDraw();
        pGraphicsJava2D.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.hsb != null) {
            pGraphicsJava2D.pushMatrix();
            pGraphicsJava2D.translate(this.hsb.getX(), this.hsb.getY());
            pGraphicsJava2D.image((PImage)this.hsb.getBuffer(), 0.0f, 0.0f);
            pGraphicsJava2D.popMatrix();
        }
        if (this.vsb != null) {
            pGraphicsJava2D.pushMatrix();
            pGraphicsJava2D.translate(this.vsb.getX(), this.vsb.getY());
            pGraphicsJava2D.rotate(1.5707964f);
            pGraphicsJava2D.image((PImage)this.vsb.getBuffer(), 0.0f, 0.0f);
            pGraphicsJava2D.popMatrix();
        }
        pGraphicsJava2D.endDraw();
        return pGraphicsJava2D;
    }

    @Override
    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 38: {
                this.moveCaretUp(this.endTLHI);
                break;
            }
            case 40: {
                this.moveCaretDown(this.endTLHI);
                break;
            }
            case 36: {
                if (bl2) {
                    this.moveCaretStartOfText(this.endTLHI);
                    break;
                }
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                if (bl2) {
                    this.moveCaretEndOfText(this.endTLHI);
                    break;
                }
                this.moveCaretEndOfLine(this.endTLHI);
                break;
            }
            case 65: {
                if (!bl2) break;
                this.moveCaretStartOfText(this.startTLHI);
                this.moveCaretEndOfText(this.endTLHI);
                bl = true;
                break;
            }
            case 67: {
                if (bl2) {
                    MClip.copy(this.getSelectedText());
                }
                bl3 = false;
                break;
            }
            case 86: {
                String string;
                if (!bl2 || (string = MClip.paste()).length() <= 0) break;
                if (this.hasSelection()) {
                    this.stext.deleteCharacters(this.pos, this.nbr);
                }
                this.stext.insertCharacters(this.pos, string);
                this.adjust = string.length();
                this.textChanged = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            this.calculateCaretPos(this.endTLHI);
            if (this.caretX > (float)this.stext.getWrapWidth()) {
                switch (n) {
                    case 35: 
                    case 37: 
                    case 38: 
                    case 40: {
                        this.moveCaretLeft(this.endTLHI);
                        bl3 = true;
                        break;
                    }
                    case 39: {
                        if (!this.moveCaretRight(this.endTLHI)) {
                            this.moveCaretLeft(this.endTLHI);
                        }
                        bl3 = true;
                    }
                }
                this.calculateCaretPos(this.endTLHI);
            }
            this.calculateCaretPos(this.endTLHI);
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            }
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        char c2 = c;
        this.newline = false;
        this.backspace = false;
        if (c2 >= ' ' && c2 < '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
            }
            this.stext.insertCharacters(this.pos, "" + c);
            this.adjust = 1;
            this.textChanged = true;
        } else if (c == '\b') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.adjust = -1;
                this.textChanged = true;
                this.backspace = true;
            }
        } else if (c == '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos, 1)) {
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            if (this.stext.insertEOL(this.pos)) {
                this.adjust = 1;
                this.textChanged = true;
                this.newline = true;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters(0, " ");
            ++this.adjust;
            this.textChanged = true;
        }
    }

    @Override
    protected boolean changeText() {
        if (!super.changeText()) {
            return false;
        }
        if (this.newline) {
            if (this.pos >= this.stext.length()) {
                this.stext.insertCharacters(this.pos, " ");
                this.stext.getLines(this.buffer.g2);
            }
            this.moveCaretRight(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
        }
        if (this.backspace && this.pos > 0) {
            char c = this.stext.getPlainText().charAt(this.pos - 1);
            if (c == '\n') {
                this.moveCaretRight(this.endTLHI);
                this.calculateCaretPos(this.endTLHI);
            }
            if (this.pos >= this.stext.length()) {
                this.stext.insertCharacters(this.pos, " ");
                this.stext.getLines(this.buffer.g2);
            }
        }
        this.startTLHI.copyFrom(this.endTLHI);
        return true;
    }

    @Override
    protected boolean moveCaretStartOfLine(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    @Override
    protected boolean moveCaretEndOfLine(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretStartOfText(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0 && textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(0);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfText(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1 && textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(this.stext.getNbrLines() - 1);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretUp(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0) {
            return false;
        }
        MStyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretDown(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1) {
            return false;
        }
        MStyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    @Override
    protected boolean moveCaretLeft(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo == 0) {
                return false;
            }
            MStyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
            textHitInfo = textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    @Override
    protected boolean moveCaretRight(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo >= this.stext.getNbrLines() - 1) {
                return false;
            }
            MStyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
            textHitInfo = textLayoutInfo.layout.getNextLeftHit(1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    public void moveCaretTo(int n, int n2) {
        try {
            MStyledString.TextLayoutHitInfo textLayoutHitInfo = this.stext.getTLHIforCharPosition(n, n2);
            if (textLayoutHitInfo != null) {
                this.startTLHI.copyFrom(textLayoutHitInfo);
                this.endTLHI.copyFrom(textLayoutHitInfo);
                this.calculateCaretPos(textLayoutHitInfo);
                this.keepCursorInView = true;
                this.showCaret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= MTextArea.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext == null || this.stext.length() == 0) {
                        this.stext = new MStyledString(" ", this.wrapWidth);
                        this.stext.getLines(this.buffer.g2);
                    }
                    this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                    this.startTLHI = new MStyledString.TextLayoutHitInfo(this.endTLHI);
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(null);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.keepCursorInView = true;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.fireEvent(new Object[]{this, MEvent.SELECTION_CHANGED});
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    protected void calculateCaretPos(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }
}

