/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Font;
import java.awt.font.TextAttribute;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MStyledString;
import processing.core.PApplet;

public abstract class MTextBase
extends MAbstractControl {
    protected static final int TPAD = 2;
    protected static final int TPAD2 = 4;
    protected static final int TPAD4 = 8;
    public MStyledString stext = new MStyledString("");
    protected Font localFont = M4P.globalFont;

    public MTextBase(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    public void setText(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.stext = new MStyledString(string, Integer.MAX_VALUE);
        this.bufferInvalid = true;
    }

    public boolean loadText(String string) {
        MStyledString mStyledString = MStyledString.load(this.winApp, string);
        if (mStyledString != null) {
            this.setStyledText(mStyledString);
            this.stext.endIdx = -1;
            this.stext.startIdx = -1;
            this.bufferInvalid = true;
            return true;
        }
        return false;
    }

    public boolean saveText(String string) {
        if (this.stext != null) {
            this.stext.endIdx = -1;
            this.stext.startIdx = -1;
            MStyledString.save(this.winApp, this.stext, string);
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
        if (font != null && font != this.localFont && this.buffer != null) {
            this.localFont = font;
            this.buffer.g2.setFont(this.localFont);
            this.bufferInvalid = true;
        }
    }

    public void setStyledText(MStyledString mStyledString) {
        if (mStyledString != null) {
            this.stext = mStyledString;
            this.stext.setWrapWidth((int)this.width - 4);
            this.bufferInvalid = true;
        }
    }

    public void setTextPlain() {
        this.stext.clearAttributes();
        this.bufferInvalid = true;
    }

    public void setTextBold(int n, int n2) {
        this.addAttributeImpl(M4P.WEIGHT, M4P.WEIGHT_BOLD, n, n2);
    }

    public void setTextBold() {
        this.addAttributeImpl(M4P.WEIGHT, M4P.WEIGHT_BOLD);
    }

    public void setTextItalic(int n, int n2) {
        this.addAttributeImpl(M4P.POSTURE, M4P.POSTURE_OBLIQUE, n, n2);
    }

    public void setTextItalic() {
        this.addAttributeImpl(M4P.POSTURE, M4P.POSTURE_OBLIQUE);
    }

    public MStyledString getStyledText() {
        return this.stext;
    }

    public String getText() {
        return this.stext.getPlainText();
    }

    protected void addAttributeImpl(TextAttribute textAttribute, Object object) {
        this.stext.addAttribute(textAttribute, object);
        this.bufferInvalid = true;
    }

    protected void addAttributeImpl(TextAttribute textAttribute, Object object, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.stext.length()) {
            n2 = this.stext.length();
        }
        this.stext.addAttribute(textAttribute, object, n, n2);
        this.bufferInvalid = true;
    }
}

