/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.Timer;
import org.gamecontrolplus.gui.MConstantsInternal;
import org.gamecontrolplus.gui.MMessenger;
import processing.core.PApplet;

public class MTimer
implements MConstantsInternal {
    protected PApplet app;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected int nrepeats = -1;
    protected Timer timer = null;

    public MTimer(PApplet pApplet, Object object, String string, int n) {
        this.app = pApplet;
        this.createEventHandler(object, string);
        if (this.eventHandlerObject != null) {
            this.timer = new Timer(n, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MTimer.this.fireEvent();
                }
            });
            this.timer.setInitialDelay(n);
            this.timer.setDelay(n);
            this.timer.stop();
        }
    }

    public MTimer(PApplet pApplet, Object object, String string, int n, int n2) {
        this.app = pApplet;
        this.createEventHandler(object, string);
        if (this.eventHandlerObject != null) {
            this.timer = new Timer(n, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MTimer.this.fireEvent();
                }
            });
            this.timer.setInitialDelay(n2);
            this.timer.setDelay(n);
            this.timer.stop();
        }
    }

    protected void createEventHandler(Object object, String string) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, MTimer.class);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{MTimer.class}});
            this.eventHandlerObject = null;
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
                if (--this.nrepeats == 0) {
                    this.stop();
                }
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.eventHandlerObject, this.eventHandlerMethodName, exception});
                System.out.println("Disabling " + this.eventHandlerMethod.getName() + " due to an unknown error");
                this.eventHandlerMethod = null;
                this.eventHandlerObject = null;
            }
        }
    }

    public void start() {
        this.nrepeats = -1;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void start(int n) {
        this.nrepeats = n;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public boolean isRunning() {
        if (this.timer != null) {
            return this.timer.isRunning();
        }
        return false;
    }

    public void setInterval(int n) {
        if (this.timer != null) {
            this.timer.setDelay(n);
        }
    }

    public void setInitialDelay(int n) {
        if (this.timer != null) {
            this.timer.setInitialDelay(n);
        }
    }

    public void setDelay(int n) {
        if (this.timer != null) {
            this.timer.setInitialDelay(n);
            this.timer.setDelay(n);
        }
    }

    public int getInterval() {
        if (this.timer != null) {
            return this.timer.getDelay();
        }
        return -1;
    }

    public int getInitialDelay() {
        if (this.timer != null) {
            return this.timer.getInitialDelay();
        }
        return -1;
    }

    public boolean isValid() {
        return this.eventHandlerObject != null && this.timer != null;
    }
}

