/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.pool.ConnectionKey;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private ConnectionFactory connectionFactory;
    private Map<ConnectionKey, LinkedList<ConnectionPool>> cache = new HashMap<ConnectionKey, LinkedList<ConnectionPool>>();
    private ObjectPoolFactory poolFactory;
    private int maximumActive = 500;
    private int maxConnections = 1;
    private int idleTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private long expiryTimeout = 0L;

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    @Override
    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        ConnectionKey key = new ConnectionKey(userName, password);
        LinkedList<ConnectionPool> pools = this.cache.get(key);
        if (pools == null) {
            pools = new LinkedList();
            this.cache.put(key, pools);
        }
        ConnectionPool connection = null;
        if (pools.size() == this.maxConnections) {
            connection = pools.removeFirst();
        }
        if (connection != null && connection.expiredCheck()) {
            connection = null;
        }
        if (connection == null) {
            ActiveMQConnection delegate = this.createConnection(key);
            connection = this.createConnectionPool(delegate);
        }
        pools.add(connection);
        return new PooledConnection(connection);
    }

    protected ConnectionPool createConnectionPool(ActiveMQConnection connection) {
        ConnectionPool result = new ConnectionPool(connection, this.getPoolFactory());
        result.setIdleTimeout(this.getIdleTimeout());
        result.setExpiryTimeout(this.getExpiryTimeout());
        return result;
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    @Override
    public void start() {
        try {
            this.stopped.set(false);
            this.createConnection();
        }
        catch (JMSException e) {
            LOG.warn("Create pooled connection during start failed.", e);
            IOExceptionSupport.create(e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("Stop the PooledConnectionFactory, number of connections in cache: " + this.cache.size());
        this.stopped.set(true);
        Iterator<LinkedList<ConnectionPool>> iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            for (ConnectionPool connection : iter.next()) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOG.warn("Close connection failed", e);
                }
            }
        }
        this.cache.clear();
    }

    public ObjectPoolFactory getPoolFactory() {
        if (this.poolFactory == null) {
            this.poolFactory = this.createPoolFactory();
        }
        return this.poolFactory;
    }

    public void setPoolFactory(ObjectPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    public int getMaximumActive() {
        return this.maximumActive;
    }

    public void setMaximumActive(int maximumActive) {
        this.maximumActive = maximumActive;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected ObjectPoolFactory createPoolFactory() {
        if (this.blockIfSessionPoolIsFull) {
            return new GenericObjectPoolFactory(null, this.maximumActive);
        }
        return new GenericObjectPoolFactory(null, this.maximumActive, 0, -1L);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }
}

