/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.Service;
import org.apache.activemq.usage.DefaultUsageCapacity;
import org.apache.activemq.usage.UsageCapacity;
import org.apache.activemq.usage.UsageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Usage<T extends Usage>
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(Usage.class);
    protected final Object usageMutex = new Object();
    protected int percentUsage;
    protected T parent;
    private UsageCapacity limiter = new DefaultUsageCapacity();
    private int percentUsageMinDelta = 1;
    private final List<UsageListener> listeners = new CopyOnWriteArrayList<UsageListener>();
    private final boolean debug = LOG.isDebugEnabled();
    protected String name;
    private float usagePortion = 1.0f;
    private final List<T> children = new CopyOnWriteArrayList<T>();
    private final List<Runnable> callbacks = new LinkedList<Runnable>();
    private int pollingTime = 100;
    private final AtomicBoolean started = new AtomicBoolean();
    private ThreadPoolExecutor executor;

    public Usage(T parent, String name, float portion) {
        this.parent = parent;
        this.usagePortion = portion;
        if (parent != null) {
            this.limiter.setLimit((long)((float)((Usage)parent).getLimit() * portion));
            name = ((Usage)parent).name + ":" + name;
        }
        this.name = name;
    }

    protected abstract long retrieveUsage();

    public void waitForSpace() throws InterruptedException {
        this.waitForSpace(0L);
    }

    public boolean waitForSpace(long timeout) throws InterruptedException {
        return this.waitForSpace(timeout, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSpace(long timeout, int highWaterMark) throws InterruptedException {
        if (this.parent != null && !((Usage)this.parent).waitForSpace(timeout, highWaterMark)) {
            return false;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.percentUsage = this.caclPercentUsage();
            if (this.percentUsage >= highWaterMark) {
                long deadline;
                long timeleft = deadline = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
                while (timeleft > 0L) {
                    this.percentUsage = this.caclPercentUsage();
                    if (this.percentUsage < highWaterMark) break;
                    this.usageMutex.wait(this.pollingTime);
                    timeleft = deadline - System.currentTimeMillis();
                }
            }
            return this.percentUsage < highWaterMark;
        }
    }

    public boolean isFull() {
        return this.isFull(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull(int highWaterMark) {
        if (this.parent != null && ((Usage)this.parent).isFull(highWaterMark)) {
            return true;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.percentUsage = this.caclPercentUsage();
            return this.percentUsage >= highWaterMark;
        }
    }

    public void addUsageListener(UsageListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsageListener(UsageListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLimit() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.limiter.getLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(long limit) {
        if (this.percentUsageMinDelta < 0) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater or equal to 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.limiter.setLimit(limit);
            this.usagePortion = 0.0f;
        }
        this.onLimitChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLimitChange() {
        int percentUsage;
        if (this.usagePortion > 0.0f && this.parent != null) {
            Object object = this.usageMutex;
            synchronized (object) {
                this.limiter.setLimit((long)((float)((Usage)this.parent).getLimit() * this.usagePortion));
            }
        }
        Object object = this.usageMutex;
        synchronized (object) {
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
        for (Usage child : this.children) {
            child.onLimitChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getUsagePortion() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.usagePortion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsagePortion(float usagePortion) {
        Object object = this.usageMutex;
        synchronized (object) {
            this.usagePortion = usagePortion;
        }
        this.onLimitChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsageMinDelta() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsageMinDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPercentUsageMinDelta(int percentUsageMinDelta) {
        int percentUsage;
        if (percentUsageMinDelta < 1) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater than 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.percentUsageMinDelta = percentUsageMinDelta;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.retrieveUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPercentUsage(int value) {
        Object object = this.usageMutex;
        synchronized (object) {
            int oldValue = this.percentUsage;
            this.percentUsage = value;
            if (oldValue != value) {
                this.fireEvent(oldValue, value);
            }
        }
    }

    protected int caclPercentUsage() {
        if (this.limiter.getLimit() == 0L) {
            return 0;
        }
        return (int)(this.retrieveUsage() * 100L / this.limiter.getLimit() / (long)this.percentUsageMinDelta * (long)this.percentUsageMinDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(final int oldPercentUsage, final int newPercentUsage) {
        if (this.debug) {
            LOG.debug(this.getName() + ": usage change from: " + oldPercentUsage + "% of available memory, to: " + newPercentUsage + "% of available memory");
        }
        if (this.started.get()) {
            if (oldPercentUsage >= 100 && newPercentUsage < 100) {
                Object object = this.usageMutex;
                synchronized (object) {
                    this.usageMutex.notifyAll();
                    if (!this.callbacks.isEmpty()) {
                        for (Runnable callback : new ArrayList<Runnable>(this.callbacks)) {
                            this.getExecutor().execute(callback);
                        }
                        this.callbacks.clear();
                    }
                }
            }
            if (!this.listeners.isEmpty()) {
                Runnable listenerNotifier = new Runnable(){

                    @Override
                    public void run() {
                        for (UsageListener l : Usage.this.listeners) {
                            l.onUsageChanged(Usage.this, oldPercentUsage, newPercentUsage);
                        }
                    }
                };
                if (this.started.get()) {
                    this.getExecutor().execute(listenerNotifier);
                } else {
                    LOG.warn("Not notifying memory usage change to listeners on shutdown");
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Usage(" + this.getName() + ") percentUsage=" + this.percentUsage + "%, usage=" + this.retrieveUsage() + ", limit=" + this.limiter.getLimit() + ", percentUsageMinDelta=" + this.percentUsageMinDelta + "%" + (this.parent != null ? ";Parent:" + ((Usage)this.parent).toString() : "");
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.parent != null) {
                this.parent.addChild((Usage)this);
            }
            for (Usage t : this.children) {
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            if (this.parent != null) {
                this.parent.removeChild((Usage)this);
            }
            Object object = this.usageMutex;
            synchronized (object) {
                this.usageMutex.notifyAll();
                for (Runnable callback : new ArrayList<Runnable>(this.callbacks)) {
                    callback.run();
                }
                this.callbacks.clear();
            }
            for (Usage t : this.children) {
                t.stop();
            }
        }
    }

    protected void addChild(T child) {
        this.children.add(child);
        if (this.started.get()) {
            ((Usage)child).start();
        }
    }

    protected void removeChild(T child) {
        this.children.remove(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCallbackWhenNotFull(final Runnable callback) {
        Runnable r;
        if (this.parent != null && ((Usage)this.parent).notifyCallbackWhenNotFull(r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Usage.this.usageMutex;
                synchronized (object) {
                    if (Usage.this.percentUsage >= 100) {
                        Usage.this.callbacks.add(callback);
                    } else {
                        callback.run();
                    }
                }
            }
        })) {
            return true;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            if (this.percentUsage >= 100) {
                this.callbacks.add(callback);
                return true;
            }
            return false;
        }
    }

    public UsageCapacity getLimiter() {
        return this.limiter;
    }

    public void setLimiter(UsageCapacity limiter) {
        this.limiter = limiter;
    }

    public int getPollingTime() {
        return this.pollingTime;
    }

    public void setPollingTime(int pollingTime) {
        this.pollingTime = pollingTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getParent() {
        return this.parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

