/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslTransport;

public abstract class AbstractProtocolCodec
implements ProtocolCodec {
    protected int writeBufferSize = 65536;
    protected long writeCounter = 0L;
    protected GatheringByteChannel writeChannel = null;
    protected DataByteArrayOutputStream nextWriteBuffer = new DataByteArrayOutputStream(this.writeBufferSize);
    protected long lastWriteIoSize = 0L;
    protected LinkedList<ByteBuffer> writeBuffer = new LinkedList();
    private long writeBufferRemaining = 0L;
    protected long readCounter = 0L;
    protected int readBufferSize = 65536;
    protected ReadableByteChannel readChannel = null;
    protected ByteBuffer readBuffer = ByteBuffer.allocate(this.readBufferSize);
    protected ByteBuffer directReadBuffer = null;
    protected int readEnd;
    protected int readStart;
    protected int lastReadIoSize;
    protected Action nextDecodeAction;
    protected boolean trim = true;

    public void setWritableByteChannel(WritableByteChannel channel) throws SocketException {
        this.writeChannel = (GatheringByteChannel)channel;
        if (this.writeChannel instanceof SocketChannel) {
            this.writeBufferSize = ((SocketChannel)this.writeChannel).socket().getSendBufferSize();
        } else if (this.writeChannel instanceof SslTransport.SSLChannel) {
            this.writeBufferSize = ((SslTransport.SSLChannel)this.writeChannel).socket().getSendBufferSize();
        }
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean full() {
        return this.writeBufferRemaining >= (long)this.writeBufferSize;
    }

    public boolean isEmpty() {
        return this.writeBufferRemaining == 0L && this.nextWriteBuffer.size() == 0;
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getLastWriteSize() {
        return this.lastWriteIoSize;
    }

    protected abstract void encode(Object var1) throws IOException;

    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.isEmpty();
        this.encode(value);
        if (this.nextWriteBuffer.size() >= this.writeBufferSize >> 1) {
            this.flushNextWriteBuffer();
        }
        if (wasEmpty) {
            return ProtocolCodec.BufferState.WAS_EMPTY;
        }
        return ProtocolCodec.BufferState.NOT_EMPTY;
    }

    protected void writeDirect(ByteBuffer value) throws IOException {
        int nextnextPospos = this.nextWriteBuffer.position();
        int valuevalueLengthlength = value.remaining();
        int available = this.nextWriteBuffer.getData().length - nextnextPospos;
        if (available > valuevalueLengthlength) {
            value.get(this.nextWriteBuffer.getData(), nextnextPospos, valuevalueLengthlength);
            this.nextWriteBuffer.position(nextnextPospos + valuevalueLengthlength);
        } else {
            if (this.nextWriteBuffer.size() != 0) {
                this.flushNextWriteBuffer();
            }
            this.writeBuffer.add(value);
            this.writeBufferRemaining += (long)value.remaining();
        }
    }

    protected void flushNextWriteBuffer() {
        int nextnextSizesize = Math.min(Math.max(this.nextWriteBuffer.position(), 80), this.writeBufferSize);
        ByteBuffer bb = this.nextWriteBuffer.toBuffer().toByteBuffer();
        this.writeBuffer.add(bb);
        this.writeBufferRemaining += (long)bb.remaining();
        this.nextWriteBuffer = new DataByteArrayOutputStream(nextnextSizesize);
    }

    public ProtocolCodec.BufferState flush() throws IOException {
        block0: while (true) {
            if (this.writeBufferRemaining != 0L) {
                if (this.writeBuffer.size() == 1) {
                    ByteBuffer b = this.writeBuffer.getFirst();
                    this.lastWriteIoSize = this.writeChannel.write(b);
                    if (this.lastWriteIoSize == 0L) {
                        return ProtocolCodec.BufferState.NOT_EMPTY;
                    }
                    this.writeBufferRemaining -= this.lastWriteIoSize;
                    this.writeCounter += this.lastWriteIoSize;
                    if (b.hasRemaining()) continue;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                    continue;
                }
                ByteBuffer[] buffers = this.writeBuffer.toArray(new ByteBuffer[this.writeBuffer.size()]);
                this.lastWriteIoSize = this.writeChannel.write(buffers, 0, buffers.length);
                if (this.lastWriteIoSize == 0L) {
                    return ProtocolCodec.BufferState.NOT_EMPTY;
                }
                this.writeBufferRemaining -= this.lastWriteIoSize;
                this.writeCounter += this.lastWriteIoSize;
                while (true) {
                    if (this.writeBuffer.isEmpty() || this.writeBuffer.getFirst().hasRemaining()) continue block0;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                }
            }
            if (this.nextWriteBuffer.size() == 0) {
                return ProtocolCodec.BufferState.EMPTY;
            }
            this.flushNextWriteBuffer();
        }
    }

    protected void onBufferFlushed(ByteBuffer byteBuffer) {
    }

    protected abstract Action initialDecodeAction();

    public void setReadableByteChannel(ReadableByteChannel channel) throws SocketException {
        this.readChannel = channel;
        if (this.readChannel instanceof SocketChannel) {
            this.readBufferSize = ((SocketChannel)this.readChannel).socket().getReceiveBufferSize();
        } else if (this.readChannel instanceof SslTransport.SSLChannel) {
            this.writeBufferSize = ((SslTransport.SSLChannel)this.readChannel).socket().getReceiveBufferSize();
        }
        if (this.nextDecodeAction == null) {
            this.nextDecodeAction = this.initialDecodeAction();
        }
    }

    public void unread(byte[] buffer) {
        assert (this.readCounter == 0L);
        this.readBuffer.put(buffer);
        this.readCounter += (long)buffer.length;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public long getLastReadSize() {
        return this.lastReadIoSize;
    }

    public Object read() throws IOException {
        Object command = null;
        while (command == null) {
            if (this.directReadBuffer != null) {
                while (this.directReadBuffer.hasRemaining()) {
                    this.lastReadIoSize = this.readChannel.read(this.directReadBuffer);
                    this.readCounter += (long)this.lastReadIoSize;
                    if (this.lastReadIoSize == -1) {
                        throw new EOFException("Peer disconnected");
                    }
                    if (this.lastReadIoSize != 0) continue;
                    return null;
                }
                command = this.nextDecodeAction.apply();
                continue;
            }
            if (this.readEnd == this.readBuffer.position()) {
                if (this.readBuffer.remaining() == 0) {
                    int size = this.readEnd - this.readStart;
                    int newCapacity = 0;
                    newCapacity = this.readStart == 0 ? size + this.readBufferSize : (size > this.readBufferSize ? size + this.readBufferSize : this.readBufferSize);
                    byte[] newnewBufferbuffer = new byte[newCapacity];
                    if (size > 0) {
                        System.arraycopy(this.readBuffer.array(), this.readStart, newnewBufferbuffer, 0, size);
                    }
                    this.readBuffer = ByteBuffer.wrap(newnewBufferbuffer);
                    this.readBuffer.position(size);
                    this.readStart = 0;
                    this.readEnd = size;
                }
                int p = this.readBuffer.position();
                this.lastReadIoSize = this.readChannel.read(this.readBuffer);
                this.readCounter += (long)this.lastReadIoSize;
                if (this.lastReadIoSize == -1) {
                    ++this.readCounter;
                    throw new EOFException("Peer disconnected");
                }
                if (this.lastReadIoSize == 0) {
                    return null;
                }
            }
            command = this.nextDecodeAction.apply();
            assert (this.readStart <= this.readEnd);
            assert (this.readEnd <= this.readBuffer.position());
        }
        return command;
    }

    protected Buffer readUntil(Byte octet) throws ProtocolException {
        return this.readUntil(octet, -1);
    }

    protected Buffer readUntil(Byte octet, int max) throws ProtocolException {
        return this.readUntil(octet, max, "Maximum protocol buffer length exeeded");
    }

    protected Buffer readUntil(Byte octet, int max, String msg) throws ProtocolException {
        byte[] array = this.readBuffer.array();
        Buffer buf = new Buffer(array, this.readEnd, this.readBuffer.position() - this.readEnd);
        int pos = buf.indexOf(octet);
        if (pos >= 0) {
            int offset = this.readStart;
            this.readEnd += pos + 1;
            this.readStart = this.readEnd;
            int length = this.readEnd - offset;
            if (max >= 0 && length > max) {
                throw new ProtocolException(msg);
            }
            return new Buffer(array, offset, length);
        }
        this.readEnd += buf.length;
        if (max >= 0 && this.readEnd - this.readStart > max) {
            throw new ProtocolException(msg);
        }
        return null;
    }

    protected Buffer readBytes(int length) {
        if (this.readBuffer.position() - this.readStart < length) {
            this.readEnd = this.readBuffer.position();
            return null;
        }
        int offset = this.readStart;
        this.readStart = this.readEnd = offset + length;
        return new Buffer(this.readBuffer.array(), offset, length);
    }

    protected Buffer peekBytes(int length) {
        if (this.readBuffer.position() - this.readStart < length) {
            this.readEnd = this.readBuffer.position();
            return null;
        }
        return new Buffer(this.readBuffer.array(), this.readStart, length);
    }

    protected Boolean readDirect(ByteBuffer buffer) {
        assert (this.directReadBuffer == null || this.directReadBuffer == buffer);
        if (buffer.hasRemaining()) {
            int limit = this.readBuffer.position();
            int transferSize = Math.min(limit - this.readStart, buffer.remaining());
            byte[] readBufferArray = this.readBuffer.array();
            buffer.put(readBufferArray, this.readStart, transferSize);
            int trailingSize = limit - (this.readStart + transferSize);
            if (trailingSize > 0) {
                System.arraycopy(readBufferArray, this.readStart + transferSize, readBufferArray, this.readStart, trailingSize);
            }
            this.readBuffer.position(this.readStart + trailingSize);
        }
        if (buffer.hasRemaining()) {
            this.directReadBuffer = buffer;
            return false;
        }
        this.directReadBuffer = null;
        buffer.flip();
        return true;
    }

    public static interface Action {
        public Object apply() throws IOException;
    }
}

