/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;

public class TcpTransportServer
implements TransportServer {
    private final String bindScheme;
    private final InetSocketAddress bindAddress;
    private int backlog = 100;
    private ServerSocketChannel channel;
    private TransportServerListener listener;
    private DispatchQueue dispatchQueue;
    private DispatchSource acceptSource;
    private int receiveBufferSize = 65536;

    public TcpTransportServer(URI location) throws UnknownHostException {
        this.bindScheme = location.getScheme();
        String host = location.getHost();
        host = host == null || host.length() == 0 ? "::" : host;
        this.bindAddress = new InetSocketAddress(InetAddress.getByName(host), location.getPort());
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    public void suspend() {
        this.acceptSource.suspend();
    }

    public void resume() {
        this.acceptSource.resume();
    }

    public void start() throws Exception {
        this.start(null);
    }

    public void start(Runnable onCompleted) throws Exception {
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
            try {
                this.channel.socket().setReceiveBufferSize(this.receiveBufferSize);
            }
            catch (SocketException ignore) {
                // empty catch block
            }
            this.channel.socket().bind(this.bindAddress, this.backlog);
        }
        catch (IOException e) {
            throw new IOException("Failed to bind to server socket: " + this.bindAddress + " due to: " + e);
        }
        this.acceptSource = Dispatch.createSource(this.channel, 16, this.dispatchQueue);
        this.acceptSource.setEventHandler(new Runnable(){

            public void run() {
                try {
                    SocketChannel client = TcpTransportServer.this.channel.accept();
                    while (client != null) {
                        TcpTransportServer.this.handleSocket(client);
                        client = TcpTransportServer.this.channel.accept();
                    }
                }
                catch (Exception e) {
                    TcpTransportServer.this.listener.onAcceptError(e);
                }
            }
        });
        this.acceptSource.setCancelHandler(new Runnable(){

            public void run() {
                try {
                    TcpTransportServer.this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    public String getBoundAddress() {
        try {
            return new URI(this.bindScheme, null, this.bindAddress.getAddress().getHostAddress(), this.channel.socket().getLocalPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws Exception {
        this.stop(null);
    }

    public void stop(final Runnable onCompleted) throws Exception {
        if (this.acceptSource.isCanceled()) {
            onCompleted.run();
        } else {
            this.acceptSource.setCancelHandler(new Runnable(){

                public void run() {
                    try {
                        TcpTransportServer.this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    onCompleted.run();
                }
            });
            this.acceptSource.cancel();
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    protected final void handleSocket(SocketChannel socket) throws Exception {
        TcpTransport transport = this.createTransport();
        transport.connected(socket);
        this.listener.onAccept(transport);
    }

    protected TcpTransport createTransport() {
        return new TcpTransport();
    }

    public String toString() {
        return this.getBoundAddress();
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }
}

