/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.cli;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Publisher {
    private final MQTT mqtt = new MQTT();
    private QoS qos = QoS.AT_MOST_ONCE;
    private UTF8Buffer topic;
    private Buffer body;
    private boolean debug;
    private boolean retain;
    private long count = 1L;
    private long sleep;
    private boolean prefixCounter;

    private static void displayHelpAndExit(int exitCode) {
        Publisher.stdout("");
        Publisher.stdout("This is a simple mqtt client that will publish to a topic.");
        Publisher.stdout("");
        Publisher.stdout("Arguments: [-h host] [-k keepalive] [-c] [-i id] [-u username [-p password]]");
        Publisher.stdout("           [--will-topic topic [--will-payload payload] [--will-qos qos] [--will-retain]]");
        Publisher.stdout("           [-d] [-n count] [-s sleep] [-q qos] [-r] -t topic ( -pc | -m message | -z | -f file )");
        Publisher.stdout("");
        Publisher.stdout("");
        Publisher.stdout(" -h : mqtt host uri to connect to. Defaults to tcp://localhost:1883.");
        Publisher.stdout(" -k : keep alive in seconds for this client. Defaults to 60.");
        Publisher.stdout(" -c : disable 'clean session'.");
        Publisher.stdout(" -i : id to use for this client. Defaults to a random id.");
        Publisher.stdout(" -u : provide a username (requires MQTT 3.1 broker)");
        Publisher.stdout(" -p : provide a password (requires MQTT 3.1 broker)");
        Publisher.stdout(" --will-topic : the topic on which to publish the client Will.");
        Publisher.stdout(" --will-payload : payload for the client Will, which is sent by the broker in case of");
        Publisher.stdout("                  unexpected disconnection. If not given and will-topic is set, a zero");
        Publisher.stdout("                  length message will be sent.");
        Publisher.stdout(" --will-qos : QoS level for the client Will.");
        Publisher.stdout(" --will-retain : if given, make the client Will retained.");
        Publisher.stdout(" -d : display debug info on stderr");
        Publisher.stdout(" -n : the number of times to publish the message");
        Publisher.stdout(" -s : the number of milliseconds to sleep between publish operations (defaut: 0)");
        Publisher.stdout(" -q : quality of service level to use for the publish. Defaults to 0.");
        Publisher.stdout(" -r : message should be retained.");
        Publisher.stdout(" -t : mqtt topic to publish to.");
        Publisher.stdout(" -m : message payload to send.");
        Publisher.stdout(" -z : send a null (zero length) message.");
        Publisher.stdout(" -f : send the contents of a file as the message.");
        Publisher.stdout(" -pc : prefix a message counter to the message");
        Publisher.stdout("");
        System.exit(exitCode);
    }

    private static void stdout(Object x) {
        System.out.println(x);
    }

    private static void stderr(Object x) {
        System.err.println(x);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            Publisher.stderr("Invalid usage: Missing argument");
            Publisher.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Publisher main = new Publisher();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                int v;
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    Publisher.displayHelpAndExit(0);
                    continue;
                }
                if ("-h".equals(arg)) {
                    main.mqtt.setHost(Publisher.shift(argl));
                    continue;
                }
                if ("-k".equals(arg)) {
                    main.mqtt.setKeepAlive(Short.parseShort(Publisher.shift(argl)));
                    continue;
                }
                if ("-c".equals(arg)) {
                    main.mqtt.setCleanSession(false);
                    continue;
                }
                if ("-i".equals(arg)) {
                    main.mqtt.setClientId(Publisher.shift(argl));
                    continue;
                }
                if ("-u".equals(arg)) {
                    main.mqtt.setUserName(Publisher.shift(argl));
                    continue;
                }
                if ("-p".equals(arg)) {
                    main.mqtt.setPassword(Publisher.shift(argl));
                    continue;
                }
                if ("--will-topic".equals(arg)) {
                    main.mqtt.setWillTopic(Publisher.shift(argl));
                    continue;
                }
                if ("--will-payload".equals(arg)) {
                    main.mqtt.setWillMessage(Publisher.shift(argl));
                    continue;
                }
                if ("--will-qos".equals(arg)) {
                    v = Integer.parseInt(Publisher.shift(argl));
                    if (v > QoS.values().length) {
                        Publisher.stderr("Invalid qos value : " + v);
                        Publisher.displayHelpAndExit(1);
                    }
                    main.mqtt.setWillQos(QoS.values()[v]);
                    continue;
                }
                if ("--will-retain".equals(arg)) {
                    main.mqtt.setWillRetain(true);
                    continue;
                }
                if ("-d".equals(arg)) {
                    main.debug = true;
                    continue;
                }
                if ("-n".equals(arg)) {
                    main.count = Long.parseLong(Publisher.shift(argl));
                    continue;
                }
                if ("-s".equals(arg)) {
                    main.sleep = Long.parseLong(Publisher.shift(argl));
                    continue;
                }
                if ("-q".equals(arg)) {
                    v = Integer.parseInt(Publisher.shift(argl));
                    if (v > QoS.values().length) {
                        Publisher.stderr("Invalid qos value : " + v);
                        Publisher.displayHelpAndExit(1);
                    }
                    main.qos = QoS.values()[v];
                    continue;
                }
                if ("-r".equals(arg)) {
                    main.retain = true;
                    continue;
                }
                if ("-t".equals(arg)) {
                    main.topic = new UTF8Buffer(Publisher.shift(argl));
                    continue;
                }
                if ("-m".equals(arg)) {
                    main.body = new UTF8Buffer(Publisher.shift(argl) + "\n");
                    continue;
                }
                if ("-z".equals(arg)) {
                    main.body = new UTF8Buffer("");
                    continue;
                }
                if ("-f".equals(arg)) {
                    File file = new File(Publisher.shift(argl));
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    try {
                        byte[] data = new byte[(int)raf.length()];
                        raf.seek(0L);
                        raf.readFully(data);
                        main.body = new Buffer(data);
                        continue;
                    }
                    finally {
                        raf.close();
                        continue;
                    }
                }
                if ("-pc".equals(arg)) {
                    main.prefixCounter = true;
                    continue;
                }
                Publisher.stderr("Invalid usage: unknown option: " + arg);
                Publisher.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                Publisher.stderr("Invalid usage: argument not a number");
                Publisher.displayHelpAndExit(1);
            }
        }
        if (main.topic == null) {
            Publisher.stderr("Invalid usage: no topic specified.");
            Publisher.displayHelpAndExit(1);
        }
        if (main.body == null) {
            Publisher.stderr("Invalid usage: -z -m or -f must be specified.");
            Publisher.displayHelpAndExit(1);
        }
        main.execute();
        System.exit(0);
    }

    private void execute() {
        final CallbackConnection connection = this.mqtt.callbackConnection();
        final CountDownLatch done = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                this.setName("MQTT client shutdown");
                connection.getDispatchQueue().execute(new Runnable(){

                    public void run() {
                        connection.disconnect(new Callback<Void>(){

                            @Override
                            public void onSuccess(Void value) {
                                done.countDown();
                            }

                            @Override
                            public void onFailure(Throwable value) {
                                done.countDown();
                            }
                        });
                    }
                });
            }
        });
        connection.listener(new Listener(){

            public void onConnected() {
                if (Publisher.this.debug) {
                    Publisher.stderr("Connected");
                }
            }

            public void onDisconnected() {
                if (Publisher.this.debug) {
                    Publisher.stderr("Disconnected");
                }
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
            }

            public void onFailure(Throwable value) {
                if (Publisher.this.debug) {
                    value.printStackTrace();
                } else {
                    Publisher.stderr(value);
                }
                System.exit(2);
            }
        });
        connection.resume();
        connection.connect(new Callback<Void>(){

            @Override
            public void onFailure(Throwable value) {
                if (Publisher.this.debug) {
                    value.printStackTrace();
                } else {
                    Publisher.stderr(value);
                }
                System.exit(2);
            }

            @Override
            public void onSuccess(Void value) {
            }
        });
        new Runnable(){
            long sent = 0L;

            public void run() {
                final 4 publish = this;
                Buffer message = Publisher.this.body;
                if (Publisher.this.prefixCounter) {
                    long id = this.sent + 1L;
                    ByteArrayOutputStream os = new ByteArrayOutputStream(message.length + 15);
                    os.write(new AsciiBuffer(Long.toString(id)));
                    os.write(58);
                    os.write(Publisher.this.body);
                    message = os.toBuffer();
                }
                connection.publish(Publisher.this.topic, message, Publisher.this.qos, Publisher.this.retain, new Callback<Void>(){

                    @Override
                    public void onSuccess(Void value) {
                        ++sent;
                        if (Publisher.this.debug) {
                            Publisher.stdout("Sent message #" + sent);
                        }
                        if (sent < Publisher.this.count) {
                            if (Publisher.this.sleep > 0L) {
                                System.out.println("Sleeping");
                                connection.getDispatchQueue().executeAfter(Publisher.this.sleep, TimeUnit.MILLISECONDS, publish);
                            } else {
                                connection.getDispatchQueue().execute(publish);
                            }
                        } else {
                            connection.disconnect(new Callback<Void>(){

                                @Override
                                public void onSuccess(Void value) {
                                    done.countDown();
                                }

                                @Override
                                public void onFailure(Throwable value) {
                                    done.countDown();
                                }
                            });
                        }
                    }

                    @Override
                    public void onFailure(Throwable value) {
                        Publisher.stderr("Publish failed: " + value);
                        if (Publisher.this.debug) {
                            value.printStackTrace();
                        }
                        System.exit(2);
                    }
                });
            }
        }.run();
        try {
            done.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

