/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.MarketPosition;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
public class Broker {
    private long id;
    private String username;
    private String password;
    private String key;
    private String queueName;
    private boolean enabled;
    private boolean local;
    private boolean wholesale;
    private double cash;
    private HashMap<Integer, MarketPosition> mktPositions;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public Broker(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, string);
        this.id = IdGenerator.createId();
        this.queueName = null;
        this.local = false;
        this.wholesale = false;
        this.cash = 0.0;
        this.username = username;
        this.mktPositions = new HashMap();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Broker(String username, boolean local, boolean wholesale) {
        String string = username;
        boolean bl = local;
        boolean bl2 = wholesale;
        Object[] objectArray = new Object[]{string, Conversions.booleanObject(bl), Conversions.booleanObject(bl2)};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, objectArray);
        this.id = IdGenerator.createId();
        this.queueName = null;
        this.local = false;
        this.wholesale = false;
        this.cash = 0.0;
        this.username = username;
        this.mktPositions = new HashMap();
        this.local = local;
        this.wholesale = wholesale;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void updateCash(double depositAmount) {
        this.cash += depositAmount;
    }

    public double getCashBalance() {
        return this.cash;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Broker addMarketPosition(MarketPosition marketPosition, int n) {
        void posn;
        void slot;
        MarketPosition marketPosition2 = marketPosition;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this, marketPosition2, Conversions.intObject(n2));
        this.mktPositions.put((int)slot, (MarketPosition)posn);
        Broker broker = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return broker;
    }

    public Broker addMarketPosition(MarketPosition posn, Timeslot slot) {
        return this.addMarketPosition(posn, slot.getSerialNumber());
    }

    public MarketPosition findMarketPositionByTimeslot(int slot) {
        return this.mktPositions.get(slot);
    }

    public MarketPosition findMarketPositionByTimeslot(Timeslot slot) {
        return this.findMarketPositionByTimeslot(slot.getSerialNumber());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public boolean isEnabled() {
        return this.enabled || this.isLocal() && this.isWholesale();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocal() {
        return this.local;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setLocal(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.local = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public boolean isWholesale() {
        return this.wholesale;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setWholesale(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.wholesale = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public String toString() {
        return this.username;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String toQueueName() {
        if (this.queueName != null) {
            return this.queueName;
        }
        return this.getUsername();
    }

    public void receiveMessage(Object object) {
    }

    static {
        Factory factory = new Factory("Broker.java", Class.forName("org.powertac.common.Broker"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Broker", "java.lang.String:", "username:", ""), 75);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Broker", "java.lang.String:boolean:boolean:", "username:local:wholesale:", ""), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addMarketPosition", "org.powertac.common.Broker", "org.powertac.common.MarketPosition:int:", "posn:slot:", "", "org.powertac.common.Broker"), 155);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLocal", "org.powertac.common.Broker", "boolean:", "value:", "", "void"), 234);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWholesale", "org.powertac.common.Broker", "boolean:", "value:", "", "void"), 249);
    }
}

