/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="cust-info")
public class CustomerInfo {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private int population;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private double controllableKWh;
    @XStreamAsAttribute
    private double upRegulationKW;
    @XStreamAsAttribute
    private double downRegulationKW;
    @XStreamAsAttribute
    private boolean multiContracting;
    @XStreamAsAttribute
    private boolean canNegotiate;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public CustomerInfo(String name, int population) {
        String string = name;
        int n = population;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this, string, Conversions.intObject(n));
        this.id = IdGenerator.createId();
        this.controllableKWh = 0.0;
        this.upRegulationKW = 0.0;
        this.downRegulationKW = 0.0;
        this.multiContracting = false;
        this.canNegotiate = false;
        this.powerType = PowerType.CONSUMPTION;
        this.name = name;
        this.population = population;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPopulation() {
        return this.population;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setPopulation(Integer n) {
        void population;
        Integer n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, n2);
        this.population = population.intValue();
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withPowerType(PowerType powerType) {
        void type;
        PowerType powerType2 = powerType;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, powerType2);
        this.powerType = type;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isMultiContracting() {
        return this.multiContracting;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withMultiContracting(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.multiContracting = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isCanNegotiate() {
        return this.canNegotiate;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withCanNegotiate(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.canNegotiate = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public String toString() {
        return "CustomerInfo(" + this.name + ")";
    }

    static {
        Factory factory = new Factory("CustomerInfo.java", Class.forName("org.powertac.common.CustomerInfo"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.CustomerInfo", "java.lang.String:int:", "name:population:", ""), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPopulation", "org.powertac.common.CustomerInfo", "java.lang.Integer:", "population:", "", "void"), 119);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPowerType", "org.powertac.common.CustomerInfo", "org.powertac.common.enumerations.PowerType:", "type:", "", "org.powertac.common.CustomerInfo"), 138);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMultiContracting", "org.powertac.common.CustomerInfo", "boolean:", "value:", "", "org.powertac.common.CustomerInfo"), 159);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withCanNegotiate", "org.powertac.common.CustomerInfo", "boolean:", "value:", "", "org.powertac.common.CustomerInfo"), 179);
    }
}

