/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.enumerations;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.HashMap;
import org.powertac.common.xml.PowerTypeConverter;

@XStreamConverter(value=PowerTypeConverter.class)
public class PowerType {
    private static HashMap<String, PowerType> index = new HashMap();
    public static final PowerType CONSUMPTION = new PowerType(TypeLabel.CONSUMPTION);
    public static final PowerType PRODUCTION = new PowerType(TypeLabel.PRODUCTION);
    public static final PowerType STORAGE = new PowerType(TypeLabel.STORAGE);
    public static final PowerType INTERRUPTIBLE_CONSUMPTION = new PowerType(TypeLabel.INTERRUPTIBLE_CONSUMPTION);
    public static final PowerType THERMAL_STORAGE_CONSUMPTION = new PowerType(TypeLabel.THERMAL_STORAGE_CONSUMPTION);
    public static final PowerType SOLAR_PRODUCTION = new PowerType(TypeLabel.SOLAR_PRODUCTION);
    public static final PowerType WIND_PRODUCTION = new PowerType(TypeLabel.WIND_PRODUCTION);
    public static final PowerType RUN_OF_RIVER_PRODUCTION = new PowerType(TypeLabel.RUN_OF_RIVER_PRODUCTION);
    public static final PowerType PUMPED_STORAGE_PRODUCTION = new PowerType(TypeLabel.PUMPED_STORAGE_PRODUCTION);
    public static final PowerType CHP_PRODUCTION = new PowerType(TypeLabel.CHP_PRODUCTION);
    public static final PowerType FOSSIL_PRODUCTION = new PowerType(TypeLabel.FOSSIL_PRODUCTION);
    public static final PowerType BATTERY_STORAGE = new PowerType(TypeLabel.BATTERY_STORAGE);
    public static final PowerType ELECTRIC_VEHICLE = new PowerType(TypeLabel.ELECTRIC_VEHICLE);
    private TypeLabel label;

    private PowerType(TypeLabel label) {
        this.label = label;
        index.put(label.toString(), this);
    }

    public boolean isConsumption() {
        return this.label == TypeLabel.CONSUMPTION || this.label == TypeLabel.ELECTRIC_VEHICLE || this.label == TypeLabel.INTERRUPTIBLE_CONSUMPTION || this.label == TypeLabel.THERMAL_STORAGE_CONSUMPTION;
    }

    public boolean isProduction() {
        return this.label == TypeLabel.PRODUCTION || this.label == TypeLabel.CHP_PRODUCTION || this.label == TypeLabel.FOSSIL_PRODUCTION || this.label == TypeLabel.RUN_OF_RIVER_PRODUCTION || this.label == TypeLabel.SOLAR_PRODUCTION || this.label == TypeLabel.WIND_PRODUCTION;
    }

    public boolean canUse(PowerType tariffType) {
        return this.equals(tariffType) || this.isConsumption() && tariffType.label == TypeLabel.CONSUMPTION || this.isProduction() && tariffType.label == TypeLabel.PRODUCTION || this.isInterruptible() && tariffType.label == TypeLabel.INTERRUPTIBLE_CONSUMPTION;
    }

    public boolean isInterruptible() {
        return this.label == TypeLabel.INTERRUPTIBLE_CONSUMPTION || this.label == TypeLabel.THERMAL_STORAGE_CONSUMPTION;
    }

    public boolean isStorage() {
        return this.label == TypeLabel.STORAGE || this.label == TypeLabel.BATTERY_STORAGE || this.label == TypeLabel.PUMPED_STORAGE_PRODUCTION;
    }

    public PowerType getGenericType() {
        if (this.isConsumption()) {
            return CONSUMPTION;
        }
        if (this.isProduction()) {
            return PRODUCTION;
        }
        if (this.isStorage()) {
            return STORAGE;
        }
        return null;
    }

    public String toString() {
        return this.label.toString();
    }

    public static PowerType valueOf(String name) {
        return index.get(name);
    }

    private static enum TypeLabel {
        CONSUMPTION,
        PRODUCTION,
        STORAGE,
        INTERRUPTIBLE_CONSUMPTION,
        THERMAL_STORAGE_CONSUMPTION,
        SOLAR_PRODUCTION,
        WIND_PRODUCTION,
        RUN_OF_RIVER_PRODUCTION,
        PUMPED_STORAGE_PRODUCTION,
        CHP_PRODUCTION,
        FOSSIL_PRODUCTION,
        BATTERY_STORAGE,
        ELECTRIC_VEHICLE;

    }
}

