/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.DomainRepo;
import org.powertac.util.ListTools;
import org.powertac.util.Predicate;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger(CustomerRepo.class.getName());
    private HashMap<Long, CustomerInfo> customers = new HashMap();

    public CustomerInfo createCustomerInfo(String name, int population) {
        CustomerInfo result = new CustomerInfo(name, population);
        this.customers.put(result.getId(), result);
        return result;
    }

    public void add(CustomerInfo customer) {
        this.customers.put(customer.getId(), customer);
    }

    public Collection<CustomerInfo> list() {
        return this.customers.values();
    }

    @Deprecated
    public int count() {
        return this.size();
    }

    public int size() {
        return this.customers.values().size();
    }

    public CustomerInfo findById(long id) {
        return this.customers.get(id);
    }

    public List<CustomerInfo> findByName(final String name) {
        return ListTools.filter(this.customers.values(), new Predicate<CustomerInfo>(){

            @Override
            public boolean apply(CustomerInfo item) {
                return name.equals(item.getName());
            }
        });
    }

    public CustomerInfo findByNameAndPowerType(final String name, final PowerType type) {
        List<CustomerInfo> candidates = ListTools.filter(this.customers.values(), new Predicate<CustomerInfo>(){

            @Override
            public boolean apply(CustomerInfo item) {
                return name.equals(item.getName()) && (type == item.getPowerType() || type == item.getPowerType().getGenericType());
            }
        });
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() > 1) {
            for (CustomerInfo customer : candidates) {
                if (type != customer.getPowerType()) continue;
                return customer;
            }
        }
        return candidates.get(0);
    }

    @Override
    public void recycle() {
        this.customers.clear();
    }
}

